/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;

public class PageContextCompileUtil {
    private PageContextCompileUtil() {
    }

    public static void validatePathAndRoute(String route, N2oParam[] pathParams, ParentRouteScope routeScope) {
        List<String> routeParams;
        List<String> list = routeParams = route == null ? null : RouteUtil.getParams(route);
        if (CollectionUtils.isEmpty(routeParams) && ArrayUtils.isEmpty((Object[])pathParams)) {
            return;
        }
        if (routeParams == null) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0435", pathParams[0].getName()));
        }
        if (pathParams == null) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u043b\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 '%s' \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d", routeParams.get(0), route));
        }
        for (N2oParam pathParam : pathParams) {
            if (!routeParams.contains(pathParam.getName())) {
                throw new N2oException(String.format("\u041c\u0430\u0440\u0448\u0440\u0443\u0442 '%s' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s'", route, pathParam.getName()));
            }
            if (routeScope == null || routeScope.getUrl() == null || !RouteUtil.getParams(routeScope.getUrl()).contains(pathParam.getName())) continue;
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c 'url'", pathParam.getName()));
        }
    }

    public static void initMapping(N2oParam[] params, Map<String, ModelLink> pathMapping, Map<String, ModelLink> targetMapping, CompileProcessor p) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return;
        }
        targetMapping.putAll(PageContextCompileUtil.initParams(Arrays.asList(params), pathMapping, p));
    }

    public static Map<String, String> initParentDatasourceIdsMap(PageContext context, CompileProcessor p) {
        HashMap<String, String> parentDatasourceIdsMap = new HashMap<String, String>();
        DataSourcesScope scope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
        if (!CollectionUtils.isEmpty((Map)scope)) {
            for (Map.Entry entry : scope.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof N2oParentDatasource)) {
                    parentDatasourceIdsMap.put((String)entry.getKey(), DatasourceUtil.getClientDatasourceId((String)entry.getKey(), p));
                    continue;
                }
                N2oParentDatasource parentDatasource = (N2oParentDatasource)v;
                if (parentDatasource.isFromParentPage()) continue;
                parentDatasourceIdsMap.put((String)entry.getKey(), context.getParentDatasourceIdsMap().get(entry.getKey()));
            }
        }
        return parentDatasourceIdsMap;
    }

    private static Map<String, ModelLink> initParams(List<N2oParam> params, Map<String, ModelLink> pathParams, CompileProcessor p) {
        if (params == null) {
            return null;
        }
        return params.stream().filter(f -> f.getName() != null && !pathParams.containsKey(f.getName())).collect(Collectors.toMap(N2oParam::getName, param -> {
            Object patt0$temp;
            ModelLink link = Redux.linkParam(param, p);
            String datasource = param.getDatasourceId();
            DataSourcesScope dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
            if (ReduxModelEnum.RESOLVE.equals((Object)link.getModel()) && Objects.equals(link.getFieldId(), "id") && (patt0$temp = dataSourcesScope.get(datasource)) instanceof N2oStandardDatasource) {
                N2oStandardDatasource sd = (N2oStandardDatasource)patt0$temp;
                link.setSubModelQuery(new SubModelQuery(sd.getQueryId()));
            }
            return link;
        }));
    }
}

