/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.filters.FilterTypeEnum;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileBindTerminalPipeline;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;

public class N2oSubModelsProcessor
implements SubModelsProcessor,
MetadataEnvironmentAware {
    private QueryProcessor queryProcessor;
    private MetadataEnvironment environment;
    private DomainProcessor domainProcessor;

    public N2oSubModelsProcessor(QueryProcessor queryProcessor, DomainProcessor domainProcessor) {
        this.queryProcessor = queryProcessor;
        this.domainProcessor = domainProcessor;
    }

    public void executeSubModels(List<SubModelQuery> subQueries, DataSet dataSet) {
        if (dataSet.isEmpty() || subQueries == null) {
            return;
        }
        for (SubModelQuery subModelQuery : subQueries) {
            CompiledQuery subQuery = subModelQuery.getQueryId() == null ? null : (CompiledQuery)((ReadCompileBindTerminalPipeline)this.environment.getReadCompileBindTerminalPipelineFunction().apply((Object)new N2oPipelineSupport(this.environment))).get((CompileContext)new QueryContext(subModelQuery.getQueryId()), dataSet);
            this.executeSubModel(subModelQuery, (Map<String, Object>)dataSet, subQuery);
        }
    }

    public CollectionPage<DataSet> getQueryResult(String queryId, DataSet params, N2oPreparedCriteria criteria) {
        CompiledQuery query = (CompiledQuery)((ReadCompileBindTerminalPipeline)this.environment.getReadCompileBindTerminalPipelineFunction().apply((Object)new N2oPipelineSupport(this.environment))).get((CompileContext)new QueryContext(queryId), params);
        return this.queryProcessor.executeOneSizeQuery(query, criteria);
    }

    private void executeSubModel(SubModelQuery subModelQuery, Map<String, Object> dataSet, CompiledQuery subQuery) {
        String valueFieldId = subModelQuery.getValueFieldId() != null ? subModelQuery.getValueFieldId() : "id";
        String labelFieldId = subModelQuery.getLabelFieldId() != null ? subModelQuery.getLabelFieldId() : "name";
        List<Map<String, Object>> subModels = this.prepareSubModels(subModelQuery, dataSet, labelFieldId, valueFieldId);
        if (subModels == null) {
            return;
        }
        if (subQuery != null && subQuery.containsFilter("id", FilterTypeEnum.EQ)) {
            this.executeQuery(subQuery, subModelQuery, subModels, labelFieldId, valueFieldId);
        } else if (subQuery == null) {
            this.resolveOptions(subModelQuery, subModels, labelFieldId, valueFieldId);
        }
    }

    private void executeQuery(CompiledQuery subQuery, SubModelQuery subModelQuery, List<Map<String, Object>> subModels, String labelFieldId, String valueFieldId) {
        QuerySimpleField field = (QuerySimpleField)subQuery.getSimpleFieldsMap().get(valueFieldId);
        if (field == null) {
            throw new N2oException(String.format("field [%s] not found in query [%s]", valueFieldId, subModelQuery.getQueryId()));
        }
        for (Map<String, Object> subModel : subModels) {
            if (subModel.get(labelFieldId) != null || subModel.get(valueFieldId) == null) {
                return;
            }
            Object value = subModel.get(valueFieldId);
            if (StringUtils.isDynamicValue((Object)value)) continue;
            N2oPreparedCriteria criteria = N2oPreparedCriteria.simpleCriteriaOneRecord((String)valueFieldId, (Object)value);
            CollectionPage subData = this.queryProcessor.executeOneSizeQuery(subQuery, criteria);
            DataSet first = (DataSet)subData.getCollection().iterator().next();
            for (AbstractField queryField : subQuery.getDisplayFields()) {
                subModel.put(queryField.getId(), first.get((Object)queryField.getId()));
            }
        }
    }

    private void resolveOptions(SubModelQuery subModelQuery, List<Map<String, Object>> subModels, String labelFieldId, String valueFieldId) {
        if (subModelQuery.getOptions() == null) {
            return;
        }
        for (Map<String, Object> subModel : subModels) {
            Object value;
            if (subModel.get(labelFieldId) != null || subModel.get(valueFieldId) == null) {
                return;
            }
            if (StringUtils.isDynamicValue((Object)subModel.get(valueFieldId)) || (value = this.domainProcessor.deserialize(subModel.get(valueFieldId))) == null) continue;
            subModelQuery.getOptions().forEach(option -> {
                if (value.equals(option.get(valueFieldId)) && option.get(labelFieldId) != null) {
                    subModel.putAll((Map<String, Object>)option);
                }
            });
        }
    }

    private List<Map<String, Object>> prepareSubModels(SubModelQuery subModelQuery, Map<String, Object> dataSet, String labelFieldId, String valueFieldId) {
        List subModels;
        Object subModelValue = subModelQuery.getSubModel() != null ? dataSet.get(subModelQuery.getSubModel()) : dataSet;
        if (subModelValue instanceof Collection) {
            Collection collection = (Collection)subModelValue;
            if (collection.isEmpty()) {
                return null;
            }
            if (!(collection.iterator().next() instanceof Map)) {
                return null;
            }
            subModels = (List)subModelValue;
            if (subModels.get(0) == null) {
                subModels.clear();
                return null;
            }
            if (((Map)subModels.get(0)).get(labelFieldId) == null && ((Map)subModels.get(0)).get(valueFieldId) == null) {
                subModels.clear();
                return null;
            }
        } else if (subModelValue instanceof Map) {
            Map subModelValueMap = (Map)subModelValue;
            subModels = Collections.singletonList(subModelValueMap);
        } else {
            return null;
        }
        return subModels;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }
}

