/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective.reader;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.ElementWrongLocation;
import net.n2oapp.framework.config.SchemaNotRegisteredException;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import org.jdom2.Namespace;

public class ReaderFactoryByMap
implements NamespaceReaderFactory,
IOProcessorAware,
MetadataEnvironmentAware {
    private Map<String, Map<String, NamespaceReader>> map = new HashMap<String, Map<String, NamespaceReader>>();
    private IOProcessor ioProcessor;

    public ReaderFactoryByMap(MetadataEnvironment environment) {
        this.ioProcessor = new IOProcessorImpl(this, environment);
    }

    public ReaderFactoryByMap register(NamespaceReader reader) {
        this.add(reader);
        return this;
    }

    public ReaderFactoryByMap register(NamespaceIO io) {
        return this.register((NamespaceReader)new ProxyNamespaceIO(io, this.ioProcessor));
    }

    public NamespaceReader produce(String elementName, Namespace ... namespaces) {
        HashMap<String, NamespaceReader> innerEngines = new HashMap<String, NamespaceReader>();
        for (Namespace namespace : namespaces) {
            if (!this.map.containsKey(namespace.getURI())) continue;
            for (Map.Entry<String, NamespaceReader> readerEntry : this.map.get(namespace.getURI()).entrySet()) {
                innerEngines.putIfAbsent(readerEntry.getKey(), readerEntry.getValue());
            }
        }
        if (innerEngines.isEmpty()) {
            throw new SchemaNotRegisteredException(elementName);
        }
        NamespaceReader reader = (NamespaceReader)innerEngines.get(elementName);
        if (reader == null) {
            throw new ElementWrongLocation(elementName);
        }
        if (reader instanceof IOProcessorAware) {
            IOProcessorAware ioProcessorAware = (IOProcessorAware)reader;
            ioProcessorAware.setIOProcessor(this.ioProcessor);
        }
        return reader;
    }

    public void add(NamespaceReader reader) {
        this.map.computeIfAbsent(reader.getNamespaceUri(), n -> new HashMap()).put(reader.getElementName(), reader);
    }

    public void setIOProcessor(IOProcessor ioProcessor) {
        this.ioProcessor = ioProcessor;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        IOProcessor iOProcessor;
        if (this.ioProcessor != null && (iOProcessor = this.ioProcessor) instanceof IOProcessorImpl) {
            IOProcessorImpl ioProcessorImpl = (IOProcessorImpl)iOProcessor;
            ioProcessorImpl.setSystemProperties(environment.getSystemProperties());
            ioProcessorImpl.setMessageSourceAccessor(environment.getMessageSource());
        }
    }

    @Generated
    public Map<String, Map<String, NamespaceReader>> getMap() {
        return this.map;
    }

    @Generated
    public void setMap(Map<String, Map<String, NamespaceReader>> map) {
        this.map = map;
    }
}

