/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scanner;

import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.scanner.DefaultInfoScanner;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.stereotype.Component;

@Component
public class DefaultXmlInfoScanner
implements DefaultInfoScanner<InfoConstructor>,
MetadataEnvironmentAware {
    public static final String DEFAULT_PATTERN = "net/n2oapp/framework/config/default/**/*.xml";
    private String pattern = "net/n2oapp/framework/config/default/**/*.xml";
    private SourceTypeRegister sourceTypeRegister;

    public DefaultXmlInfoScanner() {
    }

    public DefaultXmlInfoScanner(String pattern) {
        this.pattern = pattern;
    }

    public DefaultXmlInfoScanner(String pattern, SourceTypeRegister sourceTypeRegister) {
        this.pattern = pattern;
        this.sourceTypeRegister = sourceTypeRegister;
    }

    public List<InfoConstructor> scan() {
        return RegisterUtil.collectInfo(FileSystemUtil.getNodesByLocationPattern(this.pattern), node -> RegisterUtil.createXmlInfo(DefaultXmlInfoScanner.class, node.getLocalPath(), node.getUri(), this.sourceTypeRegister));
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.sourceTypeRegister = environment.getSourceTypeRegister();
    }

    public SourceTypeRegister getSourceTypeRegister() {
        return this.sourceTypeRegister;
    }
}

