/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.page;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.page.N2oBasePage;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.validation.standard.PageValidationUtil;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.ValidatorDatasourceIdsScope;
import org.springframework.stereotype.Component;

@Component
public class BasePageValidator
implements SourceValidator<N2oBasePage>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oBasePage.class;
    }

    public void validate(N2oBasePage page, SourceProcessor p) {
        Object[] datasources = page.getDatasources();
        Object[] actions = page.getActions();
        Object[] toolbars = page.getToolbars();
        List widgets = page.getWidgets();
        p.checkIdsUnique((IdAware[])datasources, String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s", "%s", ValidationUtils.getIdOrEmptyString(page.getId())));
        p.checkIdsUnique((IdAware[])actions, String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b %s", "%s", ValidationUtils.getIdOrEmptyString(page.getId())));
        p.checkIdsUnique((Collection)widgets, String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 %s", "%s", ValidationUtils.getIdOrEmptyString(page.getId())));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        pageScope.setWidgetIds(p.safeStreamOf((Collection)widgets).map(N2oMetadata::getId).collect(Collectors.toSet()));
        ValidatorDataSourcesScope dataSourcesScope = new ValidatorDataSourcesScope(p.safeStreamOf(datasources).collect(Collectors.toMap(N2oAbstractDatasource::getId, Function.identity())));
        ValidatorDatasourceIdsScope datasourceIdsScope = new ValidatorDatasourceIdsScope(p.safeStreamOf(datasources).map(N2oAbstractDatasource::getId).collect(Collectors.toSet()));
        MetaActions actionBarScope = new MetaActions(p.safeStreamOf(actions).collect(Collectors.toMap(ActionBar::getId, Function.identity())));
        if (actions != null) {
            Stream.of(actions).forEach(actionbar -> ValidationUtils.checkOnFailAction(actionbar.getN2oActions()));
        }
        this.checkDuplicateWidgetIdsInDatasources(widgets, datasourceIdsScope);
        PageValidationUtil.fillDatasourceIdsScopeByInlineDatasource(widgets, datasourceIdsScope, p);
        p.safeStreamOf(toolbars).forEach(n2oToolbar -> p.safeStreamOf((Collection)n2oToolbar.getAllActions()).forEach(action -> p.validate((Source)action, new Object[]{pageScope, datasourceIdsScope, dataSourcesScope})));
        p.safeStreamOf(toolbars).map(N2oToolbar::getItems).filter(Objects::nonNull).flatMap(Arrays::stream).forEach(button -> p.validate((Source)button, new Object[]{datasourceIdsScope, dataSourcesScope, actionBarScope, new ComponentScope(page)}));
        p.safeStreamOf(actions).flatMap(actionBar -> p.safeStreamOf((Object[])actionBar.getN2oActions())).forEach(action -> p.validate((Source)action, new Object[]{pageScope, datasourceIdsScope, dataSourcesScope}));
        p.safeStreamOf(datasources).forEach(datasource -> p.validate((Source)datasource, new Object[]{pageScope, datasourceIdsScope}));
        p.safeStreamOf((Object[])page.getEvents()).forEach(event -> p.validate((Source)event, new Object[]{pageScope, datasourceIdsScope, dataSourcesScope, actionBarScope}));
        BasePageValidator.checkEmptyToolbar((N2oToolbar[])toolbars);
    }

    private static void checkEmptyToolbar(N2oToolbar[] toolbars) {
        if (Objects.nonNull(toolbars)) {
            for (N2oToolbar toolbar : toolbars) {
                if (toolbar.getItems() != null || toolbar.getGenerate() != null) continue;
                throw new N2oMetadataValidationException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
            }
        }
    }

    private void checkDuplicateWidgetIdsInDatasources(List<N2oWidget> widgets, ValidatorDatasourceIdsScope datasourceIdsScope) {
        widgets.forEach(n2oWidget -> {
            if (datasourceIdsScope.contains(n2oWidget.getId())) {
                throw new N2oMetadataValidationException(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", ValidationUtils.getIdOrEmptyString(n2oWidget.getId())));
            }
            if (n2oWidget.getDatasource() != null && datasourceIdsScope.contains(n2oWidget.getDatasource().getId())) {
                throw new N2oMetadataValidationException(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 %s \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0440\u0435\u0434\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b", ValidationUtils.getIdOrEmptyString(n2oWidget.getDatasource().getId()), ValidationUtils.getIdOrEmptyString(n2oWidget.getId())));
            }
        });
    }
}

