/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.plain.N2oInputText;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class InputTextValidator
implements SourceValidator<N2oInputText>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oInputText.class;
    }

    public void validate(N2oInputText source, SourceProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getDefaultValue() != null && source.getDomain() != null) {
            this.checkDomain(source, widgetScope);
        }
        if (source.getStep() != null && source.getDomain() != null) {
            this.checkStep(source, widgetScope);
        }
    }

    private void checkDomain(N2oInputText source, WidgetScope widgetScope) {
        String message = "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 'default-value' \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 'domain=%s' \u0434\u043b\u044f \u043f\u043e\u043b\u044f '%s' \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s";
        String domain = source.getDomain();
        if ("integer".equals(domain)) {
            ValidationUtils.checkInteger(source.getDefaultValue(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("short".equals(domain)) {
            ValidationUtils.checkShort(source.getDefaultValue(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("byte".equals(domain)) {
            ValidationUtils.checkByte(source.getDefaultValue(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("numeric".equals(domain)) {
            ValidationUtils.checkDouble(source.getDefaultValue(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
    }

    private void checkStep(N2oInputText source, WidgetScope widgetScope) {
        String message = "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 'step' \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 'domain=%s' \u0434\u043b\u044f \u043f\u043e\u043b\u044f %s \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s";
        String domain = source.getDomain();
        if ("integer".equals(domain)) {
            ValidationUtils.checkInteger(source.getStep(), String.format(message, domain, ValidationUtils.getIdOrEmptyString(source.getId()), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("short".equals(domain)) {
            ValidationUtils.checkShort(source.getStep(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("byte".equals(domain)) {
            ValidationUtils.checkByte(source.getStep(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
        if ("numeric".equals(domain)) {
            ValidationUtils.checkDouble(source.getStep(), String.format(message, domain, source.getId(), ValidationUtils.getIdOrEmptyString(widgetScope.getWidgetId())));
        }
    }
}

