/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.control.plain.N2oDatePicker;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.springframework.stereotype.Component;

@Component
public class DateTimeValidator
implements SourceValidator<N2oDatePicker>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oDatePicker.class;
    }

    public void validate(N2oDatePicker source, SourceProcessor p) {
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        this.checkDate(source.getDefaultValue(), "default-value", source.getId(), widgetScope.getWidgetId());
        this.checkDate(source.getMin(), "min", source.getId(), widgetScope.getWidgetId());
        this.checkDate(source.getMax(), "max", source.getId(), widgetScope.getWidgetId());
    }

    private void checkDate(String date, String attribute, String sourceId, String widgetId) {
        if (date != null && !StringUtils.isLink((Object)date)) {
            ValidationUtils.checkDate(date, String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '%s' \u043f\u043e\u043b\u044f %s \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u0434\u043e\u043b\u0436\u043d\u043e \u0438\u043c\u0435\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442 yyyy-MM-dd HH:mm:ss \u0438\u043b\u0438 yyyy-MM-dd", attribute, ValidationUtils.getIdOrEmptyString(sourceId), ValidationUtils.getIdOrEmptyString(widgetId)));
        }
    }
}

