/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.button;

import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class SubMenuValidator
implements SourceValidator<N2oSubmenu>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSubmenu.class;
    }

    public void validate(N2oSubmenu source, SourceProcessor p) {
        if (!ArrayUtils.isEmpty((Object[])source.getMenuItems())) {
            p.safeStreamOf((Object[])source.getMenuItems()).forEach(m -> {
                p.validate((Source)m, new Object[0]);
                ValidationUtils.checkOnFailAction(m.getActions());
            });
        }
        if (source.getGenerate() != null && source.getGenerate().length == 1 && StringUtils.isEmpty((Object)source.getGenerate()[0])) {
            throw new N2oMetadataValidationException(String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432\u044b\u043f\u0430\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u043c\u0435\u043d\u044e %s \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043f\u0443\u0441\u0442\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443", this.getLabelOrId(source)));
        }
    }

    private String getLabelOrId(N2oSubmenu source) {
        return ValidationUtils.getIdOrEmptyString(source.getLabel() != null ? source.getLabel() : source.getId());
    }
}

