/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.action;

import net.n2oapp.framework.api.metadata.action.N2oAbstractMetaAction;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;

public abstract class AbstractMetaActionValidator<S extends N2oAbstractMetaAction>
implements SourceValidator<S>,
SourceClassAware {
    public void validate(S source, SourceProcessor p) {
        this.checkRefreshDatasources(source, p);
    }

    private void checkRefreshDatasources(S source, SourceProcessor p) {
        if (source.getRefreshDatasourceIds() == null) {
            return;
        }
        for (String refreshDs : source.getRefreshDatasourceIds()) {
            String operation = ValidationUtils.getIdOrEmptyString(source.getOperationId());
            ValidationUtils.checkDatasourceExistence(refreshDs, p, String.format("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 \"refresh-datasources\" \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", operation, refreshDs));
        }
    }
}

