/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.FormModeEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.api.metadata.meta.widget.form.Form;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class FormCompiler
extends BaseWidgetCompiler<Form, N2oForm> {
    public Class<N2oForm> getSourceClass() {
        return N2oForm.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.form.src";
    }

    public Form compile(N2oForm source, CompileContext<?, ?> context, CompileProcessor p) {
        Form form = new Form();
        this.compileBaseWidget(form, source, context, p);
        N2oAbstractDatasource datasource = this.getDatasourceById(source.getDatasourceId(), p);
        CompiledQuery query = this.getQuery(datasource, p);
        CompiledObject object = this.getObject(source, datasource, p);
        WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasourceId(), ReduxModelEnum.RESOLVE, p);
        MetaActions widgetActions = ActionCompileStaticProcessor.initMetaActions((ActionBarAware)source, p);
        Models models = (Models)p.getScope(Models.class);
        SubModelsScope subModelsScope = (SubModelsScope)CompileUtil.castDefault((Object)((SubModelsScope)p.getScope(SubModelsScope.class)), (Supplier[])new Supplier[]{SubModelsScope::new});
        CopiedFieldScope copiedFieldScope = (CopiedFieldScope)CompileUtil.castDefault((Object)((CopiedFieldScope)p.getScope(CopiedFieldScope.class)), (Supplier[])new Supplier[]{CopiedFieldScope::new});
        WidgetParamScope paramScope = new WidgetParamScope();
        ValidationScope validationScope = p.getScope(ValidationScope.class) == null ? new ValidationScope() : (ValidationScope)p.getScope(ValidationScope.class);
        form.getComponent().setPrompt(this.initPrompt(source, p));
        form.getComponent().setFieldsets(this.initFieldSets(source.getItems(), context, p, widgetScope, query, object, widgetActions, new ModelsScope(ReduxModelEnum.RESOLVE, widgetScope.getClientDatasourceId(), models), subModelsScope, new MomentScope(N2oValidation.ServerMomentEnum.BEFORE_OPERATION), copiedFieldScope, paramScope, new ComponentScope(source), validationScope));
        this.addParamRoutes(paramScope, context, p);
        this.compileToolbarAndAction(form, source, context, p, widgetScope, widgetActions, object, validationScope);
        form.getComponent().setModelPrefix(FormModeEnum.TWO_MODELS.equals((Object)source.getMode()) ? "edit" : "resolve");
        return form;
    }

    private Boolean initPrompt(N2oForm source, CompileProcessor p) {
        return (Boolean)CompileUtil.castDefault((Object)source.getUnsavedDataPrompt(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.form.unsaved_data_prompt"), Boolean.class)});
    }

    @Override
    protected N2oAbstractDatasource initDatasource(Form compiled, N2oForm source, CompileProcessor p) {
        N2oAbstractDatasource datasource = super.initDatasource(compiled, source, p);
        if (datasource.getSize() == null) {
            datasource.setSize((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.form.size"), Integer.class));
        }
        return datasource;
    }
}

