/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.aware.FieldsetItem;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oSetFieldSet;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesModeEnum;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oCachedDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.dependency.N2oDependency;
import net.n2oapp.framework.api.metadata.global.view.widget.dependency.N2oEnablingDependency;
import net.n2oapp.framework.api.metadata.global.view.widget.dependency.N2oVisibilityDependency;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.Dependency;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDependency;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class BaseWidgetCompiler<D extends Widget, S extends N2oWidget>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    protected abstract String getPropertyWidgetSrc();

    protected void compileBaseWidget(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        compiled.setId(this.initClientWidgetId(source, context, p));
        compiled.setClassName(source.getCssClass());
        compiled.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        compiled.setProperties(p.mapAttributes(source));
        compiled.setSrc(this.initSrc(source, p));
        compiled.setFetchOnInit((Boolean)CompileUtil.castDefault((Object)source.getFetchOnInit(), (Object)true, (Object[])new Boolean[0]));
        compiled.setFetchOnVisibility((Boolean)CompileUtil.castDefault((Object)source.getFetchOnVisibility(), (Object)true, (Object[])new Boolean[0]));
        this.compileComponent(compiled, source, p);
        this.initDatasource(compiled, source, p);
        this.compileDependencies(compiled, source, p);
    }

    private void compileComponent(D compiled, S source, CompileProcessor p) {
        if (Objects.isNull(compiled.getComponent())) {
            return;
        }
        this.compileAutoFocus(source, compiled, p);
    }

    private String initSrc(S source, CompileProcessor p) {
        String defaultWidgetSrc = null;
        if (Objects.nonNull(this.getPropertyWidgetSrc())) {
            defaultWidgetSrc = (String)p.resolve(Placeholders.property((String)this.getPropertyWidgetSrc()), String.class);
        }
        return (String)CompileUtil.castDefault((Object)source.getSrc(), defaultWidgetSrc, (Object[])new String[0]);
    }

    protected N2oAbstractDatasource initDatasource(D compiled, S source, CompileProcessor p) {
        N2oStandardDatasource datasource;
        if (Objects.isNull(source.getDatasourceId())) {
            if (Objects.isNull(source.getDatasource())) {
                datasource = new N2oStandardDatasource();
                datasource.setDefaultValuesMode(DefaultValuesModeEnum.DEFAULTS);
            } else {
                datasource = source.getDatasource();
                source.setDatasource(null);
            }
            datasource.setId(Objects.nonNull(datasource.getId()) ? datasource.getId() : source.getId());
            source.setDatasourceId(datasource.getId());
            dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
            if (Objects.nonNull(dataSourcesScope)) {
                dataSourcesScope.put(datasource.getId(), datasource);
            }
        } else {
            dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
            datasource = (N2oAbstractDatasource)dataSourcesScope.get(source.getDatasourceId());
        }
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (Objects.nonNull(pageScope)) {
            pageScope.getWidgetIdSourceDatasourceMap().put(source.getId(), datasource.getId());
        }
        if (datasource instanceof N2oStandardDatasource) {
            N2oStandardDatasource standardDatasource = datasource;
            compiled.setObjectId(standardDatasource.getObjectId());
        }
        compiled.setDatasource(DatasourceUtil.getClientDatasourceId(datasource.getId(), p));
        return datasource;
    }

    protected N2oAbstractDatasource getDatasourceById(String datasourceId, CompileProcessor p) {
        if (datasourceId == null) {
            return null;
        }
        DataSourcesScope dataSourcesScope = (DataSourcesScope)p.getScope(DataSourcesScope.class);
        if (dataSourcesScope != null) {
            return (N2oAbstractDatasource)dataSourcesScope.get(datasourceId);
        }
        return null;
    }

    private String initClientWidgetId(S source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        return Objects.nonNull(pageScope) ? DatasourceUtil.getClientWidgetId(source.getId(), pageScope.getPageId()) : context.getCompiledId((BindProcessor)((N2oCompileProcessor)p));
    }

    protected void compileToolbarAndAction(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, MetaActions metaActions, CompiledObject object, ValidationScope validationScope) {
        ActionCompileStaticProcessor.compileMetaActions(source, context, p, (PageIndexScope)p.getScope(PageIndexScope.class), new Object[]{metaActions, widgetScope, object, validationScope});
        compiled.setToolbar(ActionCompileStaticProcessor.compileToolbar(source, "n2o.api.widget.toolbar.place", context, p, new Object[]{object, metaActions, widgetScope, validationScope}));
    }

    protected void addParamRoutes(WidgetParamScope paramScope, CompileContext<?, ?> context, CompileProcessor p) {
        if (Objects.nonNull(paramScope) && MapUtils.isNotEmpty((Map)paramScope.getQueryMapping())) {
            PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
            Models models = (Models)p.getScope(Models.class);
            paramScope.getQueryMapping().forEach((k, v) -> {
                BindLink patt0$temp;
                if (context.getPathRouteMapping() == null || !context.getPathRouteMapping().containsKey(k)) {
                    if (Objects.nonNull(routes)) {
                        routes.addQueryMapping(k, v.getOnGet(), v.getOnSet());
                    }
                } else if (Objects.nonNull(models) && (patt0$temp = v.getOnSet()) instanceof ModelLink) {
                    ModelLink link = (ModelLink)patt0$temp;
                    models.add(link, link);
                }
            });
        }
    }

    private void compileAutoFocus(S source, D compiled, CompileProcessor p) {
        if (Objects.isNull(compiled.getComponent())) {
            return;
        }
        compiled.getComponent().setAutoFocus((Boolean)CompileUtil.castDefault((Object)source.getAutoFocus(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.auto_focus"), Boolean.class), () -> true}));
    }

    protected CompiledObject getObject(S source, N2oAbstractDatasource datasource, CompileProcessor p) {
        if (!(datasource instanceof N2oStandardDatasource)) {
            return null;
        }
        N2oStandardDatasource standardDatasource = (N2oStandardDatasource)datasource;
        if (Objects.nonNull(standardDatasource.getObjectId())) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(standardDatasource.getObjectId()));
        }
        if (Objects.nonNull(standardDatasource.getQueryId())) {
            CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(standardDatasource.getQueryId()));
            return query.getObject();
        }
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (Objects.nonNull(pageScope) && Objects.nonNull(pageScope.getObjectId()) && source.getId().equals(pageScope.getResultWidgetId())) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(pageScope.getObjectId()));
        }
        return null;
    }

    private void compileDependencies(D compiled, S source, CompileProcessor p) {
        WidgetDependency dependency = new WidgetDependency();
        ArrayList<Dependency> visibleConditions = new ArrayList<Dependency>();
        if (Objects.nonNull(source.getVisible())) {
            Object condition = p.resolveJS(source.getVisible(), Boolean.class);
            if (StringUtils.isJs((Object)condition)) {
                Dependency visibilityCondition = new Dependency();
                visibilityCondition.setCondition((Object)StringUtils.unwrapJs((String)((String)condition)));
                visibleConditions.add(visibilityCondition);
            } else if (condition instanceof Boolean) {
                Boolean conditionBoolean = (Boolean)condition;
                compiled.setVisible(conditionBoolean);
            }
        }
        if (Objects.nonNull(source.getDependencies())) {
            ArrayList<Dependency> enableConditions = new ArrayList<Dependency>();
            for (N2oDependency dep : source.getDependencies()) {
                Dependency condition = new Dependency();
                String unwrapped = ScriptProcessor.resolveFunction((String)StringUtils.unwrapJs((String)dep.getValue()));
                condition.setCondition((Object)unwrapped);
                String datasourceId = dep.getDatasource() == null ? compiled.getDatasource() : DatasourceUtil.getClientDatasourceId(dep.getDatasource(), p);
                ModelLink link = new ModelLink((ReduxModelEnum)CompileUtil.castDefault((Object)dep.getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]), datasourceId);
                condition.setOn(link.getLink());
                if (dep instanceof N2oVisibilityDependency) {
                    this.findByCondition(visibleConditions, unwrapped).ifPresent(visibleConditions::remove);
                    visibleConditions.add(condition);
                    continue;
                }
                if (!(dep instanceof N2oEnablingDependency)) continue;
                enableConditions.add(condition);
            }
            if (CollectionUtils.isNotEmpty(enableConditions)) {
                dependency.setEnabled(enableConditions);
            }
        }
        if (CollectionUtils.isNotEmpty(visibleConditions)) {
            dependency.setVisible(visibleConditions);
        }
        if (dependency.isNotEmpty()) {
            compiled.setDependency(dependency);
        }
    }

    protected CompiledQuery getQuery(N2oAbstractDatasource datasource, CompileProcessor p) {
        String queryId = null;
        if (datasource instanceof N2oStandardDatasource) {
            N2oStandardDatasource standardDatasource = (N2oStandardDatasource)datasource;
            queryId = standardDatasource.getQueryId();
        } else if (datasource instanceof N2oCachedDatasource) {
            N2oCachedDatasource cachedDatasource = (N2oCachedDatasource)datasource;
            queryId = cachedDatasource.getQueryId();
        }
        return Objects.nonNull(queryId) ? (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(queryId)) : null;
    }

    protected FieldSetScope initFieldSetScope(CompiledQuery query) {
        FieldSetScope scope = new FieldSetScope();
        if (Objects.nonNull(query)) {
            Map fieldsMap = query.getSimpleFieldsMap();
            for (Map.Entry entry : fieldsMap.entrySet()) {
                if (!Objects.nonNull(entry.getValue())) continue;
                scope.put((String)entry.getKey(), ((QuerySimpleField)entry.getValue()).getName());
            }
        }
        return scope;
    }

    protected List<FieldSet> initFieldSets(SourceComponent[] fields, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledQuery widgetQuery, Object ... scopes) {
        if (Objects.isNull(fields)) {
            return Collections.emptyList();
        }
        FieldSetScope fieldSetScope = this.initFieldSetScope(widgetQuery);
        IndexScope indexScope = new IndexScope();
        ArrayList<FieldSet> fieldSets = new ArrayList<FieldSet>();
        int i = 0;
        while (i < fields.length) {
            N2oFieldSet n2oFieldSet;
            SourceComponent sourceComponent = fields[i];
            if (sourceComponent instanceof N2oFieldSet) {
                N2oFieldSet fieldSet;
                n2oFieldSet = fieldSet = (N2oFieldSet)sourceComponent;
                ++i;
            } else {
                N2oSetFieldSet newFieldset = new N2oSetFieldSet();
                ArrayList<SourceComponent> newFieldsetItems = new ArrayList<SourceComponent>();
                while (i < fields.length && !(fields[i] instanceof N2oFieldSet)) {
                    newFieldsetItems.add(fields[i]);
                    ++i;
                }
                FieldsetItem[] items = new FieldsetItem[newFieldsetItems.size()];
                newFieldset.setItems(newFieldsetItems.toArray(items));
                n2oFieldSet = newFieldset;
            }
            fieldSets.add((FieldSet)p.compile((Object)n2oFieldSet, context, new Object[]{widgetQuery, widgetScope, fieldSetScope, indexScope, scopes}));
        }
        return fieldSets;
    }

    private Optional<Dependency> findByCondition(List<Dependency> dependencies, String condition) {
        if (Objects.isNull(dependencies)) {
            return Optional.empty();
        }
        return dependencies.stream().filter(dependencyCondition -> condition.equals(dependencyCondition.getCondition())).findFirst();
    }
}

