/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.HashMap;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oPagination;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oRowClick;
import net.n2oapp.framework.api.metadata.global.view.widget.table.PlaceEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShowCountTypeEnum;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.PerformActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.RoutablePayload;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.metadata.meta.widget.table.Pagination;
import net.n2oapp.framework.api.metadata.meta.widget.table.RowClick;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BaseListWidgetCompiler<D extends Widget, S extends N2oAbstractListWidget>
extends BaseWidgetCompiler<D, S> {
    protected Pagination compilePaging(N2oAbstractListWidget source, Integer size, CompileProcessor p, WidgetScope widgetScope) {
        Pagination pagination = new Pagination();
        pagination.setSize(source.getSize() != null ? source.getSize() : size);
        N2oPagination sourcePagination = source.getPagination() != null ? source.getPagination() : new N2oPagination();
        pagination.setPrev((Boolean)CompileUtil.castDefault((Object)sourcePagination.getPrev(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.prev"), Boolean.class)}));
        pagination.setNext((Boolean)CompileUtil.castDefault((Object)sourcePagination.getNext(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.next"), Boolean.class)}));
        pagination.setShowLast((Boolean)CompileUtil.castDefault((Object)sourcePagination.getShowLast(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.show_last"), Boolean.class)}));
        pagination.setShowCount((ShowCountTypeEnum)CompileUtil.castDefault((Object)sourcePagination.getShowCount(), (Supplier[])new Supplier[]{() -> (ShowCountTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.show_count"), ShowCountTypeEnum.class)}));
        pagination.setSrc(sourcePagination.getSrc());
        pagination.setPrevLabel((String)CompileUtil.castDefault((Object)sourcePagination.getPrevLabel(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.prev_label"), String.class)}));
        pagination.setPrevIcon((String)CompileUtil.castDefault((Object)sourcePagination.getPrevIcon(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.prev_icon"), String.class)}));
        pagination.setNextLabel((String)CompileUtil.castDefault((Object)sourcePagination.getNextLabel(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.next_label"), String.class)}));
        pagination.setNextIcon((String)CompileUtil.castDefault((Object)sourcePagination.getNextIcon(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.next_icon"), String.class)}));
        pagination.setClassName((String)CompileUtil.castDefault((Object)sourcePagination.getClassName(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.className"), String.class)}));
        pagination.setStyle(StylesResolver.resolveStyles(sourcePagination.getStyle()));
        pagination.setPlace((PlaceEnum)CompileUtil.castDefault((Object)sourcePagination.getPlace(), (Supplier[])new Supplier[]{() -> (PlaceEnum)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.place"), PlaceEnum.class)}));
        if (Boolean.TRUE.equals(sourcePagination.getRoutable())) {
            this.initRoute(p, widgetScope);
        }
        return pagination;
    }

    private void initRoute(CompileProcessor p, WidgetScope widgetScope) {
        String sizeIndex;
        String pageIndex;
        PageRoutes pageRoutes = (PageRoutes)p.getScope(PageRoutes.class);
        if (((PageScope)p.getScope(PageScope.class)).getWidgetIdSourceDatasourceMap().size() > 1) {
            pageIndex = widgetScope.getWidgetId().concat("_page");
            sizeIndex = widgetScope.getWidgetId().concat("_size");
        } else {
            pageIndex = "page";
            sizeIndex = "size";
        }
        this.addPagingQueryMapping(pageRoutes, pageIndex, widgetScope, RoutablePayload.PagingEnum.PAGE, p);
        this.addPagingQueryMapping(pageRoutes, sizeIndex, widgetScope, RoutablePayload.PagingEnum.SIZE, p);
    }

    private void addPagingQueryMapping(PageRoutes pageRoutes, String param, WidgetScope widgetScope, RoutablePayload.PagingEnum paramType, CompileProcessor p) {
        RoutablePayload payload = new RoutablePayload();
        payload.setId(widgetScope.getClientDatasourceId());
        HashMap<String, String> paging = new HashMap<String, String>();
        paging.put("paging.".concat(paramType.getId()), ":".concat(param));
        payload.setParams(paging);
        ReduxAction onGet = new ReduxAction((String)p.resolve(Placeholders.property((String)"n2o.api.widget.list.paging.routable.type"), String.class), (PerformActionPayload)payload);
        pageRoutes.addQueryMapping(param, onGet, Redux.createRoutablePagingLink(widgetScope.getClientDatasourceId(), paramType));
    }

    protected RowClick compileRowClick(N2oAbstractListWidget source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledObject object) {
        N2oRowClick rowClick;
        Object enabledCondition;
        RowClick rc = null;
        if (source.getRows() != null && source.getRows().getRowClick() != null && ((enabledCondition = ScriptProcessor.resolveExpression((String)(rowClick = source.getRows().getRowClick()).getEnabled())) == null || enabledCondition instanceof String || Boolean.TRUE.equals(enabledCondition))) {
            rowClick.setActions(ActionCompileStaticProcessor.initActions((ActionsAware)rowClick, p));
            if (ArrayUtils.isNotEmpty((Object[])rowClick.getActions())) {
                Action compiledAction = ActionCompileStaticProcessor.compileAction((ActionsAware)rowClick, context, p, object, widgetScope);
                rc = new RowClick(compiledAction);
                rc.setProperties(p.mapAttributes((ExtensionAttributesAware)rowClick));
                if (compiledAction != null && StringUtils.isJs((Object)enabledCondition)) {
                    rc.setEnablingCondition((String)ScriptProcessor.removeJsBraces((Object)enabledCondition));
                }
            }
        }
        return rc;
    }
}

