/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.GenerateAware;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.DisableOnEmptyModelTypeEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.control.ValidationTypeEnum;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.action.ActionCompileStaticProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.datasource.DataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.BaseButtonCompiler;
import net.n2oapp.framework.config.metadata.compile.toolbar.ButtonCompileUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class PerformButtonCompiler
extends BaseButtonCompiler<N2oButton, PerformButton>
implements MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public Class<? extends Source> getSourceClass() {
        return N2oButton.class;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public PerformButton compile(N2oButton source, CompileContext<?, ?> context, CompileProcessor p) {
        if (!ArrayUtils.isEmpty((Object[])source.getGenerate())) {
            N2oToolbar toolbar = (N2oToolbar)p.getScope(N2oToolbar.class);
            return (PerformButton)ButtonCompileUtil.generateButtons((GenerateAware)source, toolbar, this.buttonGeneratorFactory, context, p).get(0);
        }
        PerformButton button = new PerformButton();
        this.initDefaults(source, p);
        this.compileBase((AbstractButton)button, (N2oAbstractButton)source, p);
        button.setSrc(source.getSrc());
        button.setRounded(source.getRounded());
        button.setValidate(ButtonCompileUtil.compileValidate((Button)source, p, source.getDatasourceId()));
        CompiledObject compiledObject = this.initObject(p, source);
        Action action = ActionCompileStaticProcessor.compileAction((ActionsAware)source, context, p, compiledObject, new Object[0]);
        button.setAction(action);
        this.compileDependencies(source, button, p);
        return button;
    }

    @Override
    protected void initDefaults(N2oButton source, CompileProcessor p) {
        source.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)source.getActionId(), (Object[])new String[0]));
        super.initDefaults(source, p);
        source.setDatasourceId(ButtonCompileUtil.initDatasource((DatasourceIdAware)source, p));
        source.setSrc((String)CompileUtil.castDefault((Object)source.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.button.src"), String.class)}));
        source.setRounded((Boolean)CompileUtil.castDefault((Object)source.getRounded(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.button.rounded"), Boolean.class)}));
        source.setActions(ActionCompileStaticProcessor.initActions((ActionsAware)source, p));
        boolean validate = ButtonCompileUtil.initValidate((Button)source, source.getDatasourceId());
        source.setValidate(Boolean.valueOf(validate));
        source.setValidateDatasourceIds(this.initValidateDatasources(source, validate, source.getDatasourceId()));
    }

    private String[] initValidateDatasources(N2oButton source, boolean validate, String datasource) {
        if (validate) {
            if (source.getValidateDatasourceIds() != null) {
                return source.getValidateDatasourceIds();
            }
            if (source.getDatasourceId() != null) {
                return new String[]{datasource};
            }
        }
        return null;
    }

    private CompiledObject initObject(CompileProcessor p, N2oButton button) {
        N2oAbstractDatasource datasource;
        if (button.getDatasourceId() != null && p.getScope(DataSourcesScope.class) != null && (datasource = (N2oAbstractDatasource)((DataSourcesScope)p.getScope(DataSourcesScope.class)).get(button.getDatasourceId())) instanceof N2oStandardDatasource) {
            N2oStandardDatasource standardDatasource = (N2oStandardDatasource)datasource;
            if (standardDatasource.getObjectId() != null) {
                return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(standardDatasource.getObjectId()));
            }
            if (standardDatasource.getQueryId() != null) {
                return ((CompiledQuery)p.getCompiled((CompileContext)new QueryContext(standardDatasource.getQueryId()))).getObject();
            }
        }
        return (CompiledObject)p.getScope(CompiledObject.class);
    }

    protected void compileDependencies(N2oButton source, PerformButton button, CompileProcessor p) {
        Condition emptyModelCondition;
        String clientDatasource = DatasourceUtil.getClientDatasourceId(source.getDatasourceId(), p);
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        ArrayList<Condition> enabledConditions = new ArrayList<Condition>();
        if (source.getDatasourceId() != null && (emptyModelCondition = this.enabledByEmptyModelCondition(source, clientDatasource, componentScope, p)) != null) {
            enabledConditions.add(emptyModelCondition);
        }
        if (!enabledConditions.isEmpty()) {
            button.getConditions().put(ValidationTypeEnum.ENABLED, enabledConditions);
        }
        if (source.getDependencies() != null) {
            this.compileDependencies(source.getDependencies(), button, clientDatasource, source.getModel(), p);
        }
        this.compileCondition((N2oAbstractButton)source, (AbstractButton)button, p, componentScope);
    }

    private Condition enabledByEmptyModelCondition(N2oButton source, String clientDatasource, ComponentScope componentScope, CompileProcessor p) {
        boolean autoDisableCondition;
        DisableOnEmptyModelTypeEnum disableOnEmptyModel = (DisableOnEmptyModelTypeEnum)CompileUtil.castDefault((Object)source.getDisableOnEmptyModel(), (Supplier[])new Supplier[]{() -> (DisableOnEmptyModelTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.button.disable_on_empty_model"), DisableOnEmptyModelTypeEnum.class)});
        if (DisableOnEmptyModelTypeEnum.FALSE.equals((Object)disableOnEmptyModel)) {
            return null;
        }
        boolean parentIsNotCell = componentScope == null || componentScope.unwrap(N2oCell.class) == null;
        boolean bl = autoDisableCondition = DisableOnEmptyModelTypeEnum.AUTO.equals((Object)disableOnEmptyModel) && (ReduxModelEnum.RESOLVE.equals((Object)source.getModel()) || ReduxModelEnum.MULTI.equals((Object)source.getModel())) && parentIsNotCell;
        if (DisableOnEmptyModelTypeEnum.TRUE.equals((Object)disableOnEmptyModel) || autoDisableCondition) {
            Condition condition = new Condition();
            condition.setExpression("!$.isEmptyModel(this)");
            condition.setModelLink(new ModelLink(source.getModel(), clientDatasource).getLink());
            return condition;
        }
        return null;
    }

    private void compileDependencies(N2oButton.Dependency[] dependencies, PerformButton button, String clientDatasource, ReduxModelEnum buttonModel, CompileProcessor p) {
        for (N2oButton.Dependency d : dependencies) {
            ValidationTypeEnum validationType = null;
            if (d instanceof N2oButton.EnablingDependency) {
                validationType = ValidationTypeEnum.ENABLED;
            } else if (d instanceof N2oButton.VisibilityDependency) {
                validationType = ValidationTypeEnum.VISIBLE;
            }
            this.compileDependencyCondition(d, button, validationType, clientDatasource, buttonModel, p);
        }
    }

    private void compileDependencyCondition(N2oButton.Dependency dependency, PerformButton button, ValidationTypeEnum validationType, String buttonDatasource, ReduxModelEnum buttonModel, CompileProcessor p) {
        ReduxModelEnum refModel = (ReduxModelEnum)CompileUtil.castDefault((Object)dependency.getModel(), (Object)buttonModel, (Object[])new ReduxModelEnum[]{ReduxModelEnum.RESOLVE});
        Condition condition = new Condition();
        condition.setExpression(ScriptProcessor.resolveFunction((String)dependency.getValue()));
        String datasource = dependency.getDatasource() != null ? DatasourceUtil.getClientDatasourceId(dependency.getDatasource(), p) : buttonDatasource;
        condition.setModelLink(new ModelLink(refModel, datasource, null).getLink());
        if (dependency instanceof N2oButton.EnablingDependency) {
            N2oButton.EnablingDependency enablingDependency = (N2oButton.EnablingDependency)dependency;
            condition.setMessage(enablingDependency.getMessage());
        }
        if (!button.getConditions().containsKey(validationType)) {
            button.getConditions().put(validationType, new ArrayList());
        }
        ((List)button.getConditions().get(validationType)).add(condition);
    }
}

