/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.GenerateAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.apache.commons.lang3.ArrayUtils;

public class ButtonCompileUtil {
    public static String initDatasource(DatasourceIdAware source, CompileProcessor p) {
        if (Objects.nonNull(source.getDatasourceId())) {
            return source.getDatasourceId();
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (Objects.nonNull(widgetScope)) {
            return widgetScope.getDatasourceId();
        }
        return null;
    }

    public static List<String> compileValidate(Button source, CompileProcessor p, String datasource) {
        if (!Boolean.TRUE.equals(source.getValidate())) {
            return null;
        }
        if (!ArrayUtils.isEmpty((Object[])source.getValidateDatasourceIds())) {
            return Stream.of(source.getValidateDatasourceIds()).map(ds -> DatasourceUtil.getClientDatasourceId(ds, p)).toList();
        }
        if (Objects.nonNull(datasource)) {
            return Collections.singletonList(DatasourceUtil.getClientDatasourceId(datasource, p));
        }
        return null;
    }

    public static Boolean initValidate(Button source, String datasource) {
        if (ArrayUtils.isEmpty((Object[])source.getActions())) {
            return (Boolean)CompileUtil.castDefault((Object)source.getValidate(), (Object)false, (Object[])new Boolean[0]);
        }
        return (Boolean)CompileUtil.castDefault((Object)source.getValidate(), (Object)(Objects.nonNull(datasource) || Objects.nonNull(source.getValidateDatasourceIds()) ? 1 : 0), (Object[])new Boolean[0]);
    }

    public static List<AbstractButton> generateButtons(GenerateAware source, N2oToolbar toolbar, ButtonGeneratorFactory buttonGeneratorFactory, CompileContext<?, ?> context, CompileProcessor p) {
        Map map;
        ArrayList<AbstractButton> generated = new ArrayList<AbstractButton>();
        if (source instanceof N2oButton) {
            N2oButton btn = (N2oButton)source;
            map = btn.getExtAttributes();
        } else {
            map = new HashMap();
        }
        HashMap extAttributes = map;
        List.of(source.getGenerate()).forEach(type -> generated.addAll(buttonGeneratorFactory.generate(type, toolbar, context, p).stream().peek(item -> ((ExtensionAttributesAware)item).setExtAttributes(extAttributes)).map(item -> (AbstractButton)p.compile(item, context, new Object[]{p})).toList()));
        return generated;
    }

    @Generated
    private ButtonCompileUtil() {
    }
}

