/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.BasePageUtil;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.region.RoutableRegion;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.region.CompiledRegionItem;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.ComponentCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;

public abstract class BaseRegionCompiler<D extends Region, S extends N2oRegion>
extends ComponentCompiler<D, S, PageContext> {
    protected D build(D compiled, S source, CompileProcessor p) {
        this.compileComponent(compiled, source, p);
        compiled.setId((String)CompileUtil.castDefault((Object)source.getId(), (Object)this.createId(p), (Object[])new String[0]));
        return compiled;
    }

    protected abstract String createId(CompileProcessor var1);

    protected String createId(String regionName, CompileProcessor p) {
        IndexScope index = (IndexScope)p.getScope(IndexScope.class);
        return regionName + String.valueOf(Objects.nonNull(index) ? Integer.valueOf(index.get()) : "");
    }

    protected List<CompiledRegionItem> initContent(SourceComponent[] items, PageContext context, CompileProcessor p, Source source) {
        if (Objects.isNull(items) || items.length == 0) {
            return null;
        }
        ArrayList<CompiledRegionItem> content = new ArrayList<CompiledRegionItem>();
        ComponentScope componentScope = new ComponentScope(source);
        BasePageUtil.resolveRegionItems((SourceComponent[])items, item -> content.add((CompiledRegionItem)p.compile(item, (CompileContext)context, new Object[]{componentScope})), item -> content.add((CompiledRegionItem)p.compile(item, (CompileContext)context, new Object[]{componentScope})));
        return content;
    }

    protected void compileRoute(RoutableRegion source, String regionId, String property, CompileProcessor p) {
        Boolean routable = (Boolean)CompileUtil.castDefault((Object)source.getRoutable(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)property), Boolean.class)});
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (Objects.isNull(routes) || !Boolean.TRUE.equals(routable)) {
            return;
        }
        String activeParam = (String)CompileUtil.castDefault((Object)source.getActiveParam(), (Object)regionId, (Object[])new String[0]);
        routes.addQueryMapping(activeParam, Redux.dispatchSetActiveRegionEntity(regionId, activeParam), Redux.createActiveRegionEntityLink(regionId));
    }
}

