/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.Arrays;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oTestDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class TestEngineQueryTransformer
implements SourceTransformer<N2oQuery>,
SourceClassAware {
    public N2oQuery transform(N2oQuery source, SourceProcessor p) {
        if (!this.isTest(source)) {
            return source;
        }
        if (source.getFields() != null) {
            for (AbstractField abstractField : source.getFields()) {
                if (Boolean.TRUE.equals(abstractField.getIsSelected()) && abstractField.getSelectExpression() == null) {
                    abstractField.setSelectExpression(abstractField.getId());
                }
                if (!(abstractField instanceof QuerySimpleField)) continue;
                QuerySimpleField querySimpleField = (QuerySimpleField)abstractField;
                this.transformSimpleField(querySimpleField);
            }
        }
        if (source.getFilters() != null) {
            for (AbstractField abstractField : source.getFilters()) {
                if (abstractField.getMapping() != null) {
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abstractField.getText())) continue;
                    String mapping = StringUtils.unwrapSpel((String)abstractField.getMapping());
                    abstractField.setText(mapping + " " + Placeholders.colon((String)abstractField.getType().getId()) + " " + Placeholders.colon((String)mapping));
                    continue;
                }
                if (abstractField.getFilterId() == null) {
                    abstractField.setFilterId(RouteUtil.normalizeParam(abstractField.getFieldId()) + "_" + abstractField.getType().getId());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abstractField.getText())) continue;
                abstractField.setText(abstractField.getFieldId() + " " + Placeholders.colon((String)abstractField.getType().getId()) + " " + Placeholders.colon((String)abstractField.getFilterId()));
            }
        }
        return source;
    }

    private void transformSimpleField(QuerySimpleField field) {
        if (Boolean.TRUE.equals(field.getIsSorted()) && field.getSortingExpression() == null) {
            field.setSortingExpression(field.getId() + " " + Placeholders.colon((String)(field.getId() + "Direction")));
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }

    private boolean isTest(N2oQuery source) {
        return this.checkTest(source.getLists()) && this.checkTest(source.getUniques()) && this.checkTest(source.getCounts());
    }

    private boolean checkTest(N2oQuery.Selection[] selection) {
        if (selection == null) {
            return true;
        }
        return Arrays.stream(selection).noneMatch(elem -> !(elem.getInvocation() instanceof N2oTestDataProvider));
    }
}

