/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.datasource.AbstractDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oDatasource;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.CopyDependency;
import net.n2oapp.framework.api.metadata.meta.Dependency;
import net.n2oapp.framework.api.metadata.meta.DependencyTypeEnum;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.rest.Paging;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.datasource.AbstractDatasourceCompiler;
import net.n2oapp.framework.config.util.DatasourceUtil;

public abstract class BaseDatasourceCompiler<S extends N2oDatasource, D extends AbstractDatasource>
extends AbstractDatasourceCompiler<S, D> {
    public void compileDatasource(S source, D compiled, CompileProcessor p) {
        this.initDatasource((N2oAbstractDatasource)source, (AbstractDatasource)compiled, p);
        compiled.setPaging(new Paging((Integer)CompileUtil.castDefault((Object)source.getSize(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.datasource.size"), Integer.class)})));
        compiled.setDependencies(this.initDependencies((N2oDatasource)source, p));
        compiled.setValidations(this.initValidations(source, p, ReduxModelEnum.RESOLVE));
        compiled.setFilterValidations(this.initValidations(source, p, ReduxModelEnum.FILTER));
        compiled.setSorting(source.getSorting());
    }

    protected Map<String, List<Validation>> initValidations(S source, CompileProcessor p, ReduxModelEnum model) {
        ValidationScope validationScope = (ValidationScope)p.getScope(ValidationScope.class);
        if (validationScope != null) {
            return validationScope.get(source.getId(), model).stream().filter(v -> v.getSide() == null || v.getSide().contains("client")).collect(Collectors.groupingBy(Validation::getFieldId));
        }
        return Collections.emptyMap();
    }

    protected List<Dependency> initDependencies(N2oDatasource source, CompileProcessor p) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (source.getDependencies() != null) {
            for (N2oDatasource.Dependency d : source.getDependencies()) {
                ModelLink link;
                if (d instanceof N2oDatasource.FetchDependency) {
                    N2oDatasource.FetchDependency dependency = (N2oDatasource.FetchDependency)d;
                    Dependency fetchDependency = new Dependency();
                    link = new ModelLink((ReduxModelEnum)CompileUtil.castDefault((Object)dependency.getModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]), DatasourceUtil.getClientDatasourceId(dependency.getOn(), p));
                    fetchDependency.setOn(link.getLink());
                    fetchDependency.setType(DependencyTypeEnum.FETCH);
                    dependencies.add(fetchDependency);
                    continue;
                }
                if (!(d instanceof N2oDatasource.CopyDependency)) continue;
                N2oDatasource.CopyDependency dependency = (N2oDatasource.CopyDependency)d;
                CopyDependency copyDependency = new CopyDependency();
                link = new ModelLink((ReduxModelEnum)CompileUtil.castDefault((Object)dependency.getSourceModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]), DatasourceUtil.getClientDatasourceId(dependency.getOn(), p), dependency.getSourceFieldId());
                copyDependency.setOn(link.getLink());
                copyDependency.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)dependency.getTargetModel(), (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
                copyDependency.setField(dependency.getTargetFieldId());
                copyDependency.setType(DependencyTypeEnum.COPY);
                copyDependency.setSubmit((Boolean)CompileUtil.castDefault((Object)dependency.getSubmit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.dependency.copy.submit"), Boolean.class)}));
                copyDependency.setApplyOnInit((Boolean)CompileUtil.castDefault((Object)dependency.getApplyOnInit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.dependency.copy.apply_on_init"), Boolean.class)}));
                dependencies.add((Dependency)copyDependency);
            }
        }
        return dependencies;
    }
}

