/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import net.n2oapp.framework.api.metadata.Component;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oComponent;
import net.n2oapp.framework.api.metadata.control.N2oCustomField;
import net.n2oapp.framework.api.metadata.meta.control.CustomField;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;

@org.springframework.stereotype.Component
public class CustomFieldCompiler
extends FieldCompiler<CustomField, N2oCustomField> {
    public Class<? extends Source> getSourceClass() {
        return N2oCustomField.class;
    }

    public CustomField compile(N2oCustomField source, CompileContext<?, ?> context, CompileProcessor p) {
        CustomField customField = new CustomField();
        this.initDefaults(source, context, p);
        this.compileField(customField, source, context, p);
        if (source.getControls() != null) {
            if (source.getControls().length > 1) {
                customField.setControls(new ArrayList());
                for (N2oComponent component : source.getControls()) {
                    customField.getControls().add(this.compileControl(component, context, p));
                }
            } else if (source.getControls().length == 1) {
                customField.setControl(this.compileControl(source.getControls()[0], context, p));
            }
        }
        return customField;
    }

    protected Component compileControl(N2oComponent source, CompileContext<?, ?> context, CompileProcessor p) {
        Component control = (Component)p.compile((Object)source, context, new Object[0]);
        if (control instanceof StandardField) {
            StandardField standardField = (StandardField)control;
            return standardField.getControl();
        }
        return control;
    }
}

