/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oActionField;
import net.n2oapp.framework.api.metadata.control.N2oButtonField;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Button;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeUtil;
import net.n2oapp.framework.api.metadata.meta.control.ActionField;
import net.n2oapp.framework.api.metadata.meta.control.ButtonField;
import net.n2oapp.framework.config.metadata.compile.control.ActionFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.toolbar.ButtonCompileUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import org.springframework.stereotype.Component;

@Component
public class ButtonFieldCompiler
extends ActionFieldCompiler<ButtonField, N2oButtonField> {
    private static final String PROPERTY_PREFIX = "n2o.api.control.button";

    public Class<? extends Source> getSourceClass() {
        return N2oButtonField.class;
    }

    public ButtonField compile(N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p) {
        ButtonField field = new ButtonField();
        this.initDefaults(source, context, p);
        this.compileField(field, source, context, p);
        field.setColor(p.resolveJS(source.getColor()));
        field.setBadge(BadgeUtil.compileSimpleBadge((BadgeAware)source, (String)PROPERTY_PREFIX, (CompileProcessor)p));
        field.setRounded((Boolean)CompileUtil.castDefault((Object)source.getRounded(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.button.rounded"), Boolean.class)}));
        this.initItem(field, source, context, p);
        return field;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.control.button.src";
    }

    protected void initItem(ButtonField button, N2oButtonField source, CompileContext<?, ?> context, CompileProcessor p) {
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        button.setIcon(source.getIcon());
        button.setLabel(p.resolveJS(source.getLabel()));
        this.compileAction((N2oActionField)source, (ActionField)button, context, p);
        String hint = source.getDescription();
        if (hint != null) {
            button.setHint(p.resolveJS(hint.trim()));
            button.setHintPosition(source.getTooltipPosition());
        }
        if (source.getModel() == null) {
            source.setModel(ReduxModelEnum.RESOLVE);
        }
        String datasource = ButtonCompileUtil.initDatasource((DatasourceIdAware)source, p);
        boolean validate = ButtonCompileUtil.initValidate((Button)source, datasource);
        source.setValidate(Boolean.valueOf(validate));
        button.setValidate(ButtonCompileUtil.compileValidate((Button)source, p, datasource));
        button.setDatasource(DatasourceUtil.getClientDatasourceId(datasource, p));
    }
}

