/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oAlertField;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.control.AlertField;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class AlertFieldCompiler
extends FieldCompiler<AlertField, N2oAlertField> {
    public AlertField compile(N2oAlertField source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        AlertField alert = new AlertField();
        if (source.getText() != null) {
            alert.setText(p.resolveJS(source.getText().trim()));
        }
        alert.setTitle(p.resolveJS(source.getTitle()));
        alert.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        alert.setClassName(source.getCssClass());
        alert.setCloseButton((Boolean)CompileUtil.castDefault((Object)source.getCloseButton(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.alert.close_button"), Boolean.class)}));
        alert.setColor((String)CompileUtil.castDefault((Object)source.getColor(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.control.alert.color"), String.class)}));
        alert.setHref(StringUtils.hasLink((String)source.getHref()) ? p.resolveJS(source.getHref()) : RouteUtil.normalize(source.getHref()));
        this.compileField(alert, source, context, p);
        return alert;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.control.alert.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oAlertField.class;
    }
}

