/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.N2oMultiAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oConditionBranch;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oElseBranchAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oElseIfBranchAction;
import net.n2oapp.framework.api.metadata.action.ifelse.N2oIfBranchAction;
import net.n2oapp.framework.api.metadata.aware.ActionBarAware;
import net.n2oapp.framework.api.metadata.aware.ActionsAware;
import net.n2oapp.framework.api.metadata.aware.ToolbarsAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.PageIndexScope;
import net.n2oapp.framework.config.metadata.compile.action.condition.ConditionBranchesScope;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import org.apache.commons.lang3.ArrayUtils;

public class ActionCompileStaticProcessor {
    private ActionCompileStaticProcessor() {
        throw new IllegalStateException("Utility class");
    }

    public static MetaActions initMetaActions(ActionBarAware source, CompileProcessor p) {
        MetaActions metaActions = (MetaActions)p.getScope(MetaActions.class);
        if (metaActions == null) {
            metaActions = new MetaActions();
        }
        if (source.getActions() != null) {
            for (ActionBar actionBar : source.getActions()) {
                metaActions.addAction(actionBar.getId(), actionBar);
            }
        }
        return metaActions;
    }

    public static void compileMetaActions(ActionBarAware source, CompileContext<?, ?> context, CompileProcessor p, PageIndexScope pageIndexScope, Object ... scopes) {
        if (source.getActions() != null) {
            for (ActionBar a : source.getActions()) {
                ActionCompileStaticProcessor.initMultiActionIds(a.getN2oActions(), "act_multi", p, pageIndexScope);
                ActionCompileStaticProcessor.compileAction(a.getN2oActions(), null, context, p, new ComponentScope(a), pageIndexScope, scopes);
            }
        }
    }

    public static Action compileAction(N2oAction[] n2oActions, CompiledObject dsObject, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        if (ArrayUtils.isNotEmpty((Object[])n2oActions)) {
            List<N2oAction> actions = Arrays.stream(n2oActions).filter(ActionCompileStaticProcessor::isNotFailConditions).toList();
            if (actions.size() > 1) {
                N2oMultiAction n2oMultiAction = new N2oMultiAction();
                n2oMultiAction.setN2oActions(n2oActions);
                return (Action)p.compile((Object)n2oMultiAction, context, new Object[]{ActionCompileStaticProcessor.initActionObject(actions.get(0), dsObject, p), scopes});
            }
            return (Action)p.compile((Object)actions.get(0), context, new Object[]{ActionCompileStaticProcessor.initActionObject(actions.get(0), dsObject, p), ActionCompileStaticProcessor.initFailConditionBranchesScope(actions.get(0), n2oActions), scopes});
        }
        return null;
    }

    public static Toolbar compileToolbar(ToolbarsAware source, String defaultPlaceProperty, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        if (source.getToolbars() == null) {
            return null;
        }
        Toolbar toolbar = new Toolbar();
        ToolbarPlaceScope toolbarPlaceScope = new ToolbarPlaceScope((String)p.resolve(Placeholders.property((String)defaultPlaceProperty), String.class));
        for (N2oToolbar n2oToolbar : source.getToolbars()) {
            toolbar.putAll((Map)p.compile((Object)n2oToolbar, context, new Object[]{toolbarPlaceScope, scopes}));
        }
        return toolbar;
    }

    public static N2oAction[] initActions(ActionsAware source, CompileProcessor p) {
        N2oAction[] actions = null;
        if (ArrayUtils.isNotEmpty((Object[])source.getActions())) {
            actions = source.getActions();
        } else if (source.getActionId() != null) {
            MetaActions metaActions = (MetaActions)p.getScope(MetaActions.class);
            actions = metaActions.get(source.getActionId()) == null ? null : ((ActionBar)metaActions.get(source.getActionId())).getN2oActions();
        }
        ActionCompileStaticProcessor.initMultiActionIds(actions, "multi", p, null);
        return actions;
    }

    public static Action compileAction(ActionsAware source, CompileContext<?, ?> context, CompileProcessor p, @Nullable CompiledObject dsObject, Object ... scopes) {
        return ActionCompileStaticProcessor.compileAction(source.getActions(), dsObject, context, p, new ComponentScope(source, (ComponentScope)p.getScope(ComponentScope.class)), scopes);
    }

    public static boolean isNotFailConditions(N2oAction n2oAction) {
        return !(n2oAction instanceof N2oElseIfBranchAction) && !(n2oAction instanceof N2oElseBranchAction);
    }

    public static ConditionBranchesScope initFailConditionBranchesScope(N2oAction n2oAction, N2oAction[] n2oActions) {
        if (!(n2oAction instanceof N2oIfBranchAction)) {
            return null;
        }
        ArrayList<N2oConditionBranch> failBranches = new ArrayList<N2oConditionBranch>();
        int i = 0;
        while (!n2oAction.equals((Object)n2oActions[i])) {
            ++i;
        }
        ++i;
        while (i < n2oActions.length && !ActionCompileStaticProcessor.isNotFailConditions(n2oActions[i])) {
            failBranches.add((N2oConditionBranch)n2oActions[i]);
            ++i;
        }
        return new ConditionBranchesScope(failBranches);
    }

    private static CompiledObject initActionObject(N2oAction n2oAction, CompiledObject dsObject, CompileProcessor p) {
        if (dsObject != null) {
            return dsObject;
        }
        if (n2oAction.getObjectId() != null) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(n2oAction.getObjectId()));
        }
        return (CompiledObject)p.getScope(CompiledObject.class);
    }

    private static void initMultiActionIds(N2oAction[] actions, String prefix, CompileProcessor p, PageIndexScope pageIndexScope) {
        if (ArrayUtils.getLength((Object)actions) > 1) {
            PageIndexScope indexScope = (PageIndexScope)CompileUtil.castDefault((Object)pageIndexScope, (Supplier[])new Supplier[]{() -> (PageIndexScope)p.getScope(PageIndexScope.class)});
            Arrays.stream(actions).filter(ActionCompileStaticProcessor::isNotFailConditions).forEach(action -> action.setId((String)CompileUtil.castDefault((Object)action.getId(), (Object)(prefix + indexScope.get()), (Object[])new String[0])));
        }
    }
}

