/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.N2oAbstractDatasource;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.action.N2oCloseAction;
import net.n2oapp.framework.api.metadata.action.N2oCopyAction;
import net.n2oapp.framework.api.metadata.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.action.N2oRefreshAction;
import net.n2oapp.framework.api.metadata.action.SubmitActionTypeEnum;
import net.n2oapp.framework.api.metadata.aware.DatasourceIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.PageRefEnum;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.action.control.TargetEnum;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateTypeEnum;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oParentDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.PageContextCompileUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public abstract class AbstractOpenPageCompiler<D extends Action, S extends N2oAbstractPageAction>
extends AbstractActionCompiler<D, S> {
    private static final String WIDGET_ID = "$widgetId";

    @Override
    protected void initDefaults(S source, CompileProcessor p) {
        super.initDefaults(source, p);
        if (source.getDatasources() != null) {
            Stream.of(source.getDatasources()).filter(N2oStandardDatasource.class::isInstance).forEach(ds -> this.initDefaultsDatasource((N2oStandardDatasource)ds, p));
        }
        if (source.getParams() != null) {
            Stream.of(source.getParams()).forEach(param -> this.initDefaultsParam((N2oParam)param, p, source));
        }
    }

    private void initDefaultsParam(N2oParam param, CompileProcessor p, S source) {
        param.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)param.getModel(), (Supplier[])new Supplier[]{() -> this.getModelFromComponentScope(p)}));
        param.setDatasourceId((String)CompileUtil.castDefault((Object)param.getDatasourceId(), (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)}));
        if (param.getDatasourceId() == null && param.getValue() == null) {
            throw new N2oException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0434\u043b\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 %s \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f %s", param.getName(), source.getId()));
        }
        param.setRefPageId((String)CompileUtil.castDefault((Object)param.getRefPageId(), (Supplier[])new Supplier[]{() -> {
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope != null) {
                return pageScope.getPageId();
            }
            return null;
        }}));
        if (param.getName() != null && param.getName().contains(WIDGET_ID)) {
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            String clientWidgetId = widgetScope != null ? widgetScope.getClientWidgetId() : "";
            param.setName(param.getName().replace(WIDGET_ID, clientWidgetId));
        }
    }

    protected void initDefaultsDatasource(N2oStandardDatasource datasource, CompileProcessor p) {
        if (datasource.getFilters() == null) {
            return;
        }
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String pageId = pageScope == null ? null : pageScope.getPageId();
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        ReduxModelEnum modelFromComponentScope = this.getModelFromComponentScope(p);
        String localDatasourceId = this.getLocalDatasourceId(p);
        String clientWidgetId = widgetScope != null ? widgetScope.getClientWidgetId() : "";
        for (N2oPreFilter filter : datasource.getFilters()) {
            filter.setModel((ReduxModelEnum)CompileUtil.castDefault((Object)filter.getModel(), (Object)modelFromComponentScope, (Object[])new ReduxModelEnum[0]));
            filter.setDatasourceId((String)CompileUtil.castDefault((Object)filter.getDatasourceId(), (Object)localDatasourceId, (Object[])new String[0]));
            filter.setRefPageId((String)CompileUtil.castDefault((Object)filter.getRefPageId(), (Object)pageId, (Object[])new String[0]));
            if (filter.getParam() == null || !filter.getParam().contains(WIDGET_ID)) continue;
            filter.setParam(filter.getParam().replace(WIDGET_ID, clientWidgetId));
        }
    }

    protected PageContext constructContext(S source, String route, CompileProcessor p) {
        PageContext pageContext = new PageContext(source.getPageId(), route);
        this.initToolbarBySubmitOperation(source, pageContext, p);
        return pageContext;
    }

    protected PageContext initPageContext(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        this.validatePathAndRoute(source.getRoute(), (N2oParam[])source.getPathParams(), routeScope);
        ReduxModelEnum actionDataModel = this.getModelFromComponentScope(p);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String route = (String)CompileUtil.castDefault((Object)(routeScope != null ? routeScope.getUrl() : null), (Supplier[])new Supplier[]{() -> context.getRoute((BindProcessor)((N2oCompileProcessor)p)), () -> ""});
        HashMap<String, ModelLink> pathMapping = new HashMap<String, ModelLink>();
        LinkedHashMap<String, ModelLink> queryMapping = new LinkedHashMap<String, ModelLink>();
        if (routeScope != null) {
            pathMapping.putAll(routeScope.getPathMapping());
            queryMapping.putAll(routeScope.getQueryMapping());
        }
        String currentClientWidgetId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            currentClientWidgetId = widgetScope.getClientWidgetId();
        }
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        ModelLink actionModelLink = this.createActionModelLink(actionDataModel, currentClientWidgetId, componentScope, source.getPageId(), p);
        PageContextCompileUtil.initMapping((N2oParam[])source.getPathParams(), pathMapping, pathMapping, p);
        String actionRoute = this.initActionRoute(source, actionModelLink, pathMapping);
        String parentRoute = RouteUtil.normalize(route);
        route = RouteUtil.normalize(route + actionRoute);
        PageContext pageContext = this.constructContext(source, route, p);
        if (pageScope != null && pageScope.getTabIds() != null) {
            pageContext.setParentTabIds(pageScope.getTabIds());
        }
        pageContext.setPageName(source.getPageName());
        pageContext.setBreadcrumbs(this.initBreadcrumb(source, pageContext, p));
        if (source.getDatasources() != null) {
            if (pageContext.getDatasources() == null) {
                pageContext.setDatasources(new ArrayList<N2oAbstractDatasource>());
            }
            pageContext.getDatasources().addAll(Arrays.asList(source.getDatasources()));
        }
        if (source.getToolbars() != null) {
            pageContext.setToolbars(new ArrayList<N2oToolbar>(List.of(source.getToolbars())));
        }
        if (source.getActions() != null) {
            pageContext.setActions(Arrays.stream(source.getActions()).collect(Collectors.toMap(ActionBar::getId, Function.identity())));
        }
        pageContext.setParentClientWidgetId(currentClientWidgetId);
        String localDatasourceId = this.getLocalDatasourceId(p);
        pageContext.setParentLocalDatasourceId(localDatasourceId);
        pageContext.setParentClientPageId(pageScope == null ? null : pageScope.getPageId());
        pageContext.setParentRoute(RouteUtil.addQueryParams(parentRoute, queryMapping));
        if (context instanceof PageContext) {
            PageContext ctx = (PageContext)context;
            pageContext.addParentRoute(pageContext.getParentRoute(), ctx);
            pageContext.setParentDatasourceIdsMap(PageContextCompileUtil.initParentDatasourceIdsMap(ctx, p));
        }
        pageContext.setRefreshOnClose((Boolean)CompileUtil.castDefault((Object)source.getRefreshOnClose(), (Object)false, (Object[])new Boolean[0]));
        if (!(Boolean.FALSE.equals(source.getRefreshAfterSubmit()) && !pageContext.getRefreshOnClose().booleanValue() || source.getRefreshDatasourceIds() == null && localDatasourceId == null)) {
            String[] refreshDatasourceIds;
            if (source.getRefreshDatasourceIds() == null) {
                String[] stringArray = new String[1];
                v1 = stringArray;
                stringArray[0] = localDatasourceId;
            } else {
                v1 = refreshDatasourceIds = source.getRefreshDatasourceIds();
            }
            if (pageScope != null) {
                pageContext.setRefreshClientDataSourceIds(Arrays.stream(refreshDatasourceIds).map(d -> DatasourceUtil.getClientDatasourceId(d, p)).toList());
            }
        }
        pageContext.setUnsavedDataPromptOnClose((Boolean)CompileUtil.castDefault((Object)source.getUnsavedDataPromptOnClose(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.unsaved_data_prompt"), Boolean.class)}));
        pageContext.setPathRouteMapping(pathMapping);
        PageContextCompileUtil.initMapping((N2oParam[])source.getQueryParams(), pathMapping, queryMapping, p);
        pageContext.setQueryRouteMapping(queryMapping);
        pageContext.setParentModelLinks(this.collectParentLinks(actionModelLink, pathMapping.values(), queryMapping.values()));
        this.initPageRoute(compiled, route, pathMapping, queryMapping);
        p.addRoute((CompileContext)pageContext);
        return pageContext;
    }

    private List<Breadcrumb> initBreadcrumb(S source, PageContext pageContext, CompileProcessor p) {
        if (source.getBreadcrumbs() != null) {
            pageContext.setBreadcrumbFromParent(true);
            return Arrays.stream(source.getBreadcrumbs()).map(crumb -> new Breadcrumb(crumb.getLabel(), crumb.getPath())).toList();
        }
        pageContext.setBreadcrumbFromParent(false);
        return (List)p.getScope(BreadcrumbList.class);
    }

    protected List<ModelLink> collectParentLinks(ModelLink actionModelLink, Collection<ModelLink> pathLinks, Collection<ModelLink> queryLinks) {
        ArrayList<ModelLink> links = new ArrayList<ModelLink>();
        links.add(actionModelLink);
        links.addAll(pathLinks);
        links.addAll(queryLinks);
        return links;
    }

    private ModelLink createActionModelLink(ReduxModelEnum actionDataModel, String clientWidgetId, ComponentScope componentScope, String pageId, CompileProcessor p) {
        if (componentScope == null) {
            return null;
        }
        DatasourceIdAware datasourceIdAware = componentScope.unwrap(DatasourceIdAware.class);
        String datasource = datasourceIdAware != null && datasourceIdAware.getDatasourceId() != null ? DatasourceUtil.getClientDatasourceId(datasourceIdAware.getDatasourceId(), p) : clientWidgetId;
        return new ModelLink(actionDataModel, datasource, StringUtils.isLink((Object)pageId) ? StringUtils.unwrapLink((String)pageId) : "id");
    }

    private String initActionRoute(S source, ModelLink actionModelLink, Map<String, ModelLink> pathMapping) {
        boolean isDynamicPage;
        String actionRoute = source.getRoute();
        if (actionRoute != null) {
            return RouteUtil.normalize(actionRoute);
        }
        actionRoute = RouteUtil.normalize(source.getId());
        boolean bl = isDynamicPage = DynamicUtil.hasRefs((String)source.getPageId()) || DynamicUtil.isDynamic((String)source.getPageId());
        if (isDynamicPage && actionModelLink != null && ReduxModelEnum.RESOLVE.equals((Object)actionModelLink.getModel())) {
            String masterIdParam = actionModelLink.getDatasource() + "_id";
            String dynamicPageActionRoute = RouteUtil.normalize(Placeholders.colon((String)masterIdParam)) + actionRoute;
            pathMapping.put(masterIdParam, actionModelLink);
            return dynamicPageActionRoute;
        }
        return actionRoute;
    }

    protected abstract void initPageRoute(D var1, String var2, Map<String, ModelLink> var3, Map<String, ModelLink> var4);

    protected void validatePathAndRoute(String route, N2oParam[] pathParams, ParentRouteScope routeScope) {
        List<String> routeParams;
        List<String> list = routeParams = route == null ? null : RouteUtil.getParams(route);
        if (CollectionUtils.isEmpty(routeParams) && ArrayUtils.isEmpty((Object[])pathParams)) {
            return;
        }
        if (routeParams == null) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0435", pathParams[0].getName()));
        }
        if (pathParams == null) {
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u043b\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 '%s' \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d", routeParams.get(0), route));
        }
        for (N2oParam pathParam : pathParams) {
            if (!routeParams.contains(pathParam.getName())) {
                throw new N2oException(String.format("\u041c\u0430\u0440\u0448\u0440\u0443\u0442 '%s' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s'", route, pathParam.getName()));
            }
            if (routeScope == null || routeScope.getUrl() == null || !RouteUtil.getParams(routeScope.getUrl()).contains(pathParam.getName())) continue;
            throw new N2oException(String.format("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u0443\u0442\u0438 '%s' \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u043c 'url'", pathParam.getName()));
        }
    }

    @Deprecated
    protected void initToolbarBySubmitOperation(S source, PageContext context, CompileProcessor p) {
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)source.getSubmitOperationId()) || SubmitActionTypeEnum.COPY.equals((Object)source.getSubmitActionType())) {
            N2oToolbar n2oToolbar = new N2oToolbar();
            if (context.getToolbars() == null) {
                context.setToolbars(new ArrayList<N2oToolbar>());
            }
            ToolbarItem[] items = new ToolbarItem[2];
            n2oToolbar.setItems(items);
            context.getToolbars().add(n2oToolbar);
            N2oButton saveButton = new N2oButton();
            saveButton.setId(GenerateTypeEnum.SUBMIT.getId());
            saveButton.setColor("primary");
            N2oAction[] actions = null;
            ReduxModelEnum saveButtonModel = null;
            SubmitActionTypeEnum submitActionType = (SubmitActionTypeEnum)CompileUtil.castDefault((Object)source.getSubmitActionType(), (Object)SubmitActionTypeEnum.INVOKE, (Object[])new SubmitActionTypeEnum[0]);
            Boolean closeOnSuccess = (Boolean)CompileUtil.castDefault((Object)source.getCloseAfterSubmit(), (Object)true, (Object[])new Boolean[0]);
            Boolean refreshOnSuccessSubmit = (Boolean)CompileUtil.castDefault((Object)source.getRefreshAfterSubmit(), (Object)true, (Object[])new Boolean[0]);
            if (submitActionType == SubmitActionTypeEnum.COPY) {
                N2oCopyAction copyAction = new N2oCopyAction();
                copyAction.setSourceModel(source.getCopyModel());
                copyAction.setSourceDatasourceId(source.getCopyDatasourceId());
                copyAction.setSourceFieldId(source.getCopyFieldId());
                copyAction.setTargetModel(source.getTargetModel());
                copyAction.setTargetPage((PageRefEnum)CompileUtil.castDefault((Object)source.getTargetPage(), (Object)PageRefEnum.PARENT, (Object[])new PageRefEnum[0]));
                if (copyAction.getTargetPage().equals((Object)PageRefEnum.PARENT)) {
                    copyAction.setTargetDatasourceId((String)CompileUtil.castDefault((Object)source.getTargetDatasourceId(), (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)}));
                } else {
                    copyAction.setTargetDatasourceId(source.getTargetDatasourceId());
                }
                copyAction.setTargetFieldId(source.getTargetFieldId());
                copyAction.setMode(source.getCopyMode());
                copyAction.setCloseOnSuccess(closeOnSuccess);
                actions = new N2oAction[]{copyAction};
                saveButtonModel = source.getCopyModel();
            } else if (submitActionType == SubmitActionTypeEnum.INVOKE) {
                ArrayList<Object> actionList = new ArrayList<Object>();
                N2oInvokeAction invokeAction = new N2oInvokeAction();
                actionList.add(invokeAction);
                if (refreshOnSuccessSubmit.booleanValue()) {
                    if (closeOnSuccess.booleanValue()) {
                        String[] refreshDatasourceIds;
                        invokeAction.setCloseOnSuccess(Boolean.valueOf(false));
                        invokeAction.setRefreshOnSuccess(Boolean.valueOf(false));
                        for (String refreshDatasourceId : refreshDatasourceIds = this.getRefreshDatasourceId(source, p)) {
                            N2oRefreshAction refreshAction = new N2oRefreshAction();
                            refreshAction.setDatasourceId("parent_" + refreshDatasourceId);
                            actionList.add(refreshAction);
                            if (context.getDatasources() == null) {
                                context.setDatasources(new ArrayList<N2oAbstractDatasource>());
                            }
                            N2oParentDatasource parentDatasource = new N2oParentDatasource("parent_" + refreshDatasourceId, refreshDatasourceId, false);
                            context.getDatasources().add((N2oAbstractDatasource)parentDatasource);
                        }
                        N2oCloseAction closeAction = new N2oCloseAction();
                        closeAction.setPrompt(Boolean.valueOf(false));
                        actionList.add(closeAction);
                    } else {
                        invokeAction.setRefreshOnSuccess(Boolean.valueOf(true));
                        invokeAction.setCloseOnSuccess(Boolean.valueOf(false));
                        invokeAction.setRefreshDatasourceIds(source.getRefreshDatasourceIds());
                    }
                } else {
                    invokeAction.setCloseOnSuccess(closeOnSuccess);
                    invokeAction.setRefreshOnSuccess(Boolean.valueOf(false));
                }
                if (source.getRedirectUrlAfterSubmit() != null) {
                    invokeAction.setRedirectTarget((TargetEnum)CompileUtil.castDefault((Object)source.getRedirectTargetAfterSubmit(), (Supplier[])new Supplier[]{() -> RouteUtil.isApplicationUrl(source.getRedirectUrlAfterSubmit()) ? TargetEnum.APPLICATION : TargetEnum.SELF}));
                    invokeAction.setRedirectUrl(source.getRedirectUrlAfterSubmit());
                }
                invokeAction.setOperationId(source.getSubmitOperationId());
                actions = actionList.toArray(new N2oAction[0]);
                saveButtonModel = source.getSubmitModel();
            }
            saveButton.setLabel((String)CompileUtil.castDefault((Object)source.getSubmitLabel(), (Supplier[])new Supplier[]{() -> p.getMessage("n2o.api.action.toolbar.button.submit.label", new Object[0])}));
            saveButton.setActions(actions);
            saveButton.setModel((ReduxModelEnum)CompileUtil.castDefault(saveButtonModel, (Object)ReduxModelEnum.RESOLVE, (Object[])new ReduxModelEnum[0]));
            saveButton.setValidate(Boolean.valueOf(true));
            items[0] = saveButton;
            N2oButton closeButton = new N2oButton();
            closeButton.setId(GenerateTypeEnum.CLOSE.getId());
            closeButton.setLabel(p.getMessage("n2o.api.action.toolbar.button.close.label", new Object[0]));
            N2oCloseAction cancelAction = new N2oCloseAction();
            cancelAction.setId(GenerateTypeEnum.CLOSE.getId());
            closeButton.setModel(ReduxModelEnum.FILTER);
            cancelAction.setRefresh(source.getRefreshOnClose());
            closeButton.setActions((N2oAction[])new N2oCloseAction[]{cancelAction});
            closeButton.setValidate(Boolean.valueOf(false));
            items[1] = closeButton;
        }
    }

    protected String[] getRefreshDatasourceId(S source, CompileProcessor p) {
        String[] stringArray;
        if (source.getRefreshDatasourceIds() != null) {
            return source.getRefreshDatasourceIds();
        }
        String datasource = this.getLocalDatasourceId(p);
        if (datasource != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = datasource;
        } else {
            stringArray = null;
        }
        return stringArray;
    }
}

