/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.api.util.SubModelsProcessor;

public class DataModel {
    private final Map<ModelLink, DataSet> store = new HashMap<ModelLink, DataSet>();
    private static final Pattern ILLEGAL_KEY_CHARS = Pattern.compile(".*[()?+=\\\\|/<> ,!:&%^#].*");

    public void addAll(Map<String, ModelLink> links, DataSet data) {
        if (links == null || data == null) {
            return;
        }
        for (Map.Entry<String, ModelLink> entry : links.entrySet()) {
            this.add(entry.getKey(), entry.getValue(), data.get((Object)entry.getKey()));
        }
    }

    public Object add(String key, ModelLink link, Object value) {
        ModelLink widgetLink = link.getWidgetLink();
        String fieldId = link.getFieldId();
        if (fieldId != null && !ILLEGAL_KEY_CHARS.matcher(fieldId).matches()) {
            if (widgetLink != null && widgetLink.getSubModelQuery() != null) {
                this.addSubModelToStoreKey(widgetLink);
            }
            return this.storeData(widgetLink, fieldId, value);
        }
        ModelLink modelLink = widgetLink = widgetLink != null ? widgetLink : new ModelLink();
        if (value != null && !(link.getValue() instanceof DataSet)) {
            widgetLink.setValue(ScriptProcessor.resolveExpression((String)value.toString()));
            return this.storeData(widgetLink, key, value);
        }
        return this.store.put(widgetLink, (DataSet)value);
    }

    private Object storeData(ModelLink widgetLink, String key, Object value) {
        if (key.contains("[index]")) {
            return null;
        }
        DataSet data = this.store.get(widgetLink);
        if (data == null) {
            data = new DataSet();
        }
        Object old = data.put(key, value);
        this.store.put(widgetLink, data);
        return old;
    }

    private void addSubModelToStoreKey(ModelLink link) {
        ModelLink storeKey = this.store.keySet().stream().filter(k -> k.equals((Object)link)).findFirst().orElse(null);
        if (storeKey != null && storeKey.getSubModelQuery() == null) {
            storeKey.setSubModelQuery(link.getSubModelQuery());
        }
    }

    public Object getValue(ModelLink link) {
        if (link == null) {
            return null;
        }
        ModelLink widgetLink = link.getWidgetLink();
        if (widgetLink == null && link.isConst()) {
            return link.getValue();
        }
        if (widgetLink == null) {
            return null;
        }
        DataSet data = this.store.get(widgetLink);
        if (data == null) {
            return null;
        }
        String fieldId = link.getFieldId();
        return data.get((Object)fieldId);
    }

    public Object getValue(ModelLink link, String field) {
        DataSet data = this.getData(link);
        if (data == null) {
            return null;
        }
        return data.get((Object)field);
    }

    public DataSet getData(ModelLink link) {
        if (link == null) {
            return null;
        }
        ModelLink widgetLink = link.getWidgetLink();
        if (widgetLink == null) {
            return null;
        }
        return this.store.get(widgetLink);
    }

    public Function<String, Object> getDataIfAbsent(ModelLink link, SubModelsProcessor processor) {
        Map.Entry<ModelLink, DataSet> entry = this.getKeyEntry(link);
        if (entry == null) {
            return key -> null;
        }
        if (entry.getKey().getSubModelQuery() != null) {
            return key -> {
                Object value = ((DataSet)entry.getValue()).get(key);
                if (value == null && ((ModelLink)entry.getKey()).getSubModelQuery() != null) {
                    if (processor != null) {
                        processor.executeSubModels(Collections.singletonList(((ModelLink)entry.getKey()).getSubModelQuery()), (DataSet)entry.getValue());
                    }
                    return ((DataSet)entry.getValue()).get(key);
                }
                return value;
            };
        }
        return arg_0 -> ((DataSet)entry.getValue()).get(arg_0);
    }

    private Map.Entry<ModelLink, DataSet> getKeyEntry(ModelLink link) {
        if (link == null) {
            return null;
        }
        ModelLink widgetLink = link.getWidgetLink();
        return this.findEntryByLink(Objects.requireNonNullElse(widgetLink, link));
    }

    private Map.Entry<ModelLink, DataSet> findEntryByLink(ModelLink link) {
        return this.store.entrySet().stream().filter(e -> ((ModelLink)e.getKey()).equals((Object)link)).findFirst().orElse(null);
    }
}

