/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.n2oapp.framework.api.N2oWebAppEnvironment;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.config.AppConfig;
import net.n2oapp.framework.api.config.ConfigBuilder;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.test.TestContextEngine;
import org.springframework.core.env.PropertyResolver;

public class N2oConfigBuilder<T extends AppConfig>
implements ConfigBuilder<T> {
    private T appConfig;
    private Class<T> appConfigType;
    private ObjectMapper objectMapper;
    private PropertyResolver propertyResolver;
    private ContextProcessor contextProcessor;

    public N2oConfigBuilder(T appConfig, ObjectMapper objectMapper, PropertyResolver propertyResolver, ContextProcessor contextProcessor) {
        this.appConfig = appConfig;
        this.appConfigType = appConfig.getClass();
        this.objectMapper = objectMapper;
        this.propertyResolver = propertyResolver;
        this.contextProcessor = contextProcessor;
    }

    public N2oConfigBuilder(T appConfig, ObjectMapper objectMapper) {
        this(appConfig, objectMapper, (PropertyResolver)new N2oWebAppEnvironment(), new ContextProcessor((Context)new TestContextEngine()));
    }

    public N2oConfigBuilder(T appConfig) {
        this(appConfig, new ObjectMapper());
    }

    public N2oConfigBuilder(Class<T> appConfigType, ObjectMapper objectMapper, PropertyResolver propertyResolver, ContextProcessor contextProcessor) {
        this.appConfigType = appConfigType;
        this.objectMapper = objectMapper;
        this.propertyResolver = propertyResolver;
        this.contextProcessor = contextProcessor;
    }

    public N2oConfigBuilder(Class<T> appConfigType, ObjectMapper objectMapper) {
        this(appConfigType, objectMapper, (PropertyResolver)new N2oWebAppEnvironment(), new ContextProcessor((Context)new TestContextEngine()));
    }

    public N2oConfigBuilder(Class<T> appConfigType) {
        this(appConfigType, new ObjectMapper());
    }

    public ConfigBuilder<T> add(String property, Object value) {
        this.appConfig.setProperty(property, value);
        return this;
    }

    public ConfigBuilder<T> addAll(Map<String, Object> values) {
        values.forEach(this::add);
        return this;
    }

    public ConfigBuilder<T> read(String content) {
        String json = this.resolvePlaceholders(content);
        try {
            if (this.appConfig != null) {
                ObjectReader merger = this.objectMapper.readerForUpdating(this.appConfig);
                this.appConfig = (AppConfig)merger.readValue(json);
            } else {
                this.appConfig = (AppConfig)this.objectMapper.readValue(json, this.appConfigType);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public void write(Writer out) {
        try {
            this.objectMapper.writeValue(out, this.appConfig);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(File file) {
        try {
            this.objectMapper.writeValue(file, this.appConfig);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public T get() {
        return this.appConfig;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public void setContextProcessor(ContextProcessor contextProcessor) {
        this.contextProcessor = contextProcessor;
    }

    private String resolvePlaceholders(String text) {
        if (this.propertyResolver != null) {
            text = StringUtils.resolveProperties((String)text, (Object)this.propertyResolver);
        }
        if (this.contextProcessor != null) {
            text = this.contextProcessor.resolveJson(text, this.objectMapper);
        }
        return text;
    }
}

