/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.register.route.RouteUtil;

public class QueryContextUtil {
    private static final String SORTING = "sorting.";

    public static QueryContext prepareQueryContextForRouteRegister(CompiledQuery query) {
        QueryContext contextForRegister = new QueryContext(query.getId(), query.getRoute());
        List<Filter> filters = query.getFilterFieldsMap().values().stream().map(f -> {
            Filter e = new Filter();
            e.setParam(f.getParam());
            e.setFilterId(f.getFilterId());
            e.setRoutable(Boolean.valueOf(true));
            return e;
        }).toList();
        contextForRegister.setFilters(filters);
        contextForRegister.setSortingMap(QueryContextUtil.initSortingMap(query));
        return contextForRegister;
    }

    public static Map<String, String> initSortingMap(CompiledQuery query) {
        HashMap<String, String> sortingMap = new HashMap<String, String>();
        for (QuerySimpleField sortingField : query.getSortingFields()) {
            sortingMap.put(SORTING + RouteUtil.normalizeParam(sortingField.getId()), sortingField.getId());
        }
        return sortingMap;
    }

    @Generated
    private QueryContextUtil() {
    }
}

