/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.pack.XmlIOBuilder;
import net.n2oapp.framework.config.compile.pipeline.N2oEnvironment;
import net.n2oapp.framework.config.selective.XmlIOReader;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ION2oMetadataTester
implements XmlIOBuilder<ION2oMetadataTester> {
    private XmlIOReader xmlIOReader;

    public ION2oMetadataTester() {
        N2oEnvironment env = new N2oEnvironment();
        this.xmlIOReader = new XmlIOReader(env);
    }

    public ION2oMetadataTester(MetadataEnvironment environment) {
        this.xmlIOReader = new XmlIOReader(environment);
    }

    public ION2oMetadataTester(XmlIOReader xmlIOReader) {
        this.xmlIOReader = xmlIOReader;
    }

    public ION2oMetadataTester addIO(NamespaceIO io) {
        this.xmlIOReader.addIO((NamespaceIO<? extends NamespaceUriAware>)io);
        return this;
    }

    public ION2oMetadataTester addPack(MetadataPack<? super ION2oMetadataTester> pack) {
        pack.build((Object)this);
        return this;
    }

    public <T extends NamespaceUriAware> boolean isCheck(String path, Consumer<T> checker) {
        String source = FileSystemUtil.getContentFromResource((Resource)new ClassPathResource(path));
        NamespaceUriAware t = (NamespaceUriAware)this.xmlIOReader.read(source);
        if (checker != null) {
            checker.accept(t);
        }
        return this.xmlIOReader.persistAndCompareWithSample(t, source);
    }

    public <T extends NamespaceUriAware> boolean check(String path, Consumer<T> checker) {
        boolean check = this.isCheck(path, checker);
        assert (check);
        return true;
    }

    public boolean check(String path) {
        assert (this.isCheck(path, null));
        return true;
    }

    @SafeVarargs
    public final ION2oMetadataTester ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(this::addIO);
        return this;
    }

    @SafeVarargs
    public final ION2oMetadataTester packs(MetadataPack<? super ION2oMetadataTester> ... packs) {
        Stream.of(packs).forEach(p -> p.build((Object)this));
        return this;
    }
}

