/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.n2oapp.framework.config.register.storage.Node;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PathUtil {
    public static String concatFileNameAndBasePath(String fileName, String basePath) {
        if (basePath == null) {
            return fileName;
        }
        return basePath.endsWith("/") ? basePath + fileName : basePath + "/" + fileName;
    }

    public static String convertPathToClasspathUri(String path) {
        return PathUtil.isUri(path) ? path : "classpath:" + path;
    }

    public static String convertRootPathToUrl(String rootPath) {
        String prefixFile = "file:/";
        if (!((String)(rootPath = ((String)rootPath).replace('\\', '/'))).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        if (((String)rootPath).startsWith("/")) {
            rootPath = ((String)rootPath).substring(1);
        }
        if (!PathUtil.isUri((String)rootPath)) {
            return prefixFile + (String)rootPath;
        }
        rootPath = PathUtil.replacePathPatternAttribute((String)rootPath);
        return rootPath;
    }

    private static String replacePathPatternAttribute(String rootPath) {
        String pathPatternAttribute = "**/*.";
        rootPath = rootPath.contains(pathPatternAttribute) ? rootPath.substring(0, rootPath.indexOf(pathPatternAttribute)) : rootPath;
        return rootPath;
    }

    public static String convertUrlToAbsolutePath(String url) {
        String prefixFile = "file:";
        Boolean isOutsidePath = url.startsWith(prefixFile);
        if (!isOutsidePath.booleanValue()) {
            return null;
        }
        url = (url = url.substring(prefixFile.length())).contains("*") ? url.substring(0, url.indexOf("*")) : url;
        return url;
    }

    public static String convertUrlToPattern(String url, String fileExtension) {
        return PathUtil.convertUrlToPattern(url, fileExtension, "*");
    }

    public static String convertUrlToPattern(String url, String fileExtension, String fileNamePattern) {
        if (fileExtension != null && !((String)url).endsWith("." + fileExtension)) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "**/" + fileNamePattern + "." + fileExtension;
        }
        return url;
    }

    public static String convertRootPathToFilePathPattern(String rootPath, String localPath) {
        String rootUrl = PathUtil.convertRootPathToUrl(rootPath);
        return PathUtil.concatAbsoluteAndLocalPath(rootUrl, localPath);
    }

    public static String concatAbsoluteAndLocalPath(String absolutePath, String localPath) {
        if (!((String)absolutePath).endsWith("/")) {
            absolutePath = (String)absolutePath + "/";
        }
        if (localPath.startsWith("/")) {
            localPath = localPath.substring(1, localPath.length());
        }
        return ((String)absolutePath + localPath).replace("\\", "/");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource getContentByPathPattern(String path) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource resource = null;
        if (!path.contains("*")) return resourcePatternResolver.getResource(path);
        try {
            Resource[] resources = resourcePatternResolver.getResources(path);
            if (resources.length == 0) return resource;
            if (!resources[0].exists()) return resource;
            return resources[0];
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<String> extractDirs(String absolutePath) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (absolutePath == null) {
            return dirs;
        }
        File file = new File(absolutePath);
        if (file.exists()) {
            PathUtil.getDirs(absolutePath, file, dirs, false);
        }
        return dirs;
    }

    private static void getDirs(String absolutePath, File dir, List<String> result, boolean include) {
        if (dir.isDirectory()) {
            String[] subElements;
            if (include) {
                result.add(Node.calculateLocalPathByDirectoryPath(absolutePath, dir.getAbsolutePath()));
            }
            for (String subElement : subElements = dir.list()) {
                PathUtil.getDirs(absolutePath, new File(dir, subElement), result, true);
            }
        }
    }

    public static String normalize(String path) {
        if (path == null) {
            return null;
        }
        String normalized = Paths.get(path, new String[0]).toAbsolutePath().toString();
        if (normalized.endsWith("/")) {
            normalized = normalized.substring(normalized.length() - 1);
        }
        return normalized;
    }

    public static boolean isUri(String path) {
        return path != null && (path.startsWith("file") || path.startsWith("classpath") || path.startsWith("jar") || path.startsWith("war") || path.startsWith("ear") || path.startsWith("http") || path.startsWith("https"));
    }

    public static String convertAbsolutePathToLocalPath(String absolutePath, String configPath) {
        absolutePath = PathUtil.normalize(absolutePath);
        configPath = PathUtil.normalize(configPath);
        if (absolutePath == null || configPath == null) {
            return "";
        }
        return absolutePath.substring(absolutePath.indexOf(configPath) + configPath.length() + 1).replace("\\", "/");
    }

    public static Set<String> getConfigPaths(String configPath, List<String> projectPaths, String pattern, Collection<String> ignores) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (configPath != null && !configPath.isEmpty()) {
            result.add(configPath);
        }
        if (projectPaths != null) {
            if ((pattern = PathUtil.replacePathPatternAttribute(pattern.trim())).startsWith("classpath")) {
                pattern = pattern.substring(pattern.indexOf(":") + 1);
            }
            if (pattern.endsWith("/")) {
                pattern = pattern.substring(0, pattern.length() - 1);
            }
            if (ignores == null) {
                ignores = new HashSet<String>();
            }
            for (String pp : projectPaths) {
                PathUtil.extractConfPaths(result, Paths.get(pp, new String[0]), pattern, ignores);
            }
        }
        return result;
    }

    private static void extractConfPaths(Collection<String> list, Path dir, String pattern, Collection<String> ignores) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, f -> ignores.stream().noneMatch(f::endsWith) && Files.isDirectory(f, new LinkOption[0]));){
            stream.forEach(pt -> {
                if (pt.endsWith(pattern)) {
                    list.add(pt.toString());
                } else {
                    PathUtil.extractConfPaths(list, pt, pattern, ignores);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Generated
    private PathUtil() {
    }
}

