/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.storage;

import java.io.File;
import java.io.IOException;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.core.io.Resource;

public class Node {
    private String name;
    private String uri;
    private String localPath;
    private File file;

    private Node() {
    }

    public static Node byAbsolutePath(String absolutePath, String configPath) {
        Node node = new Node();
        node.localPath = PathUtil.convertAbsolutePathToLocalPath(absolutePath, configPath);
        node.uri = PathUtil.convertRootPathToUrl(absolutePath);
        return node;
    }

    public static Node byLocationPattern(Resource resource, String locationPattern) throws IOException {
        Node node = new Node();
        String uri = resource.getURI().toString();
        uri = Node.trim(uri);
        locationPattern = Node.trim(locationPattern);
        node.localPath = Node.calculateLocalPathByLocationPattern(locationPattern, uri);
        node.name = resource.getFilename();
        node.uri = uri;
        node.file = resource.getURI().getScheme().equals("file") ? resource.getFile() : null;
        return node;
    }

    public static Node byDirectory(File file, String dirPath) {
        Node node = new Node();
        String uri = file.toURI().toString();
        uri = Node.trim(uri);
        dirPath = Node.trim(dirPath);
        node.localPath = Node.calculateLocalPathByDirectoryPath(dirPath, uri);
        node.name = file.getName();
        node.uri = uri;
        node.file = file;
        return node;
    }

    public String retrieveContent() {
        return FileSystemUtil.getContentByUri(this.getUri());
    }

    public static String calculateLocalPathByLocationPattern(String locationPattern, String uri) {
        if (!locationPattern.contains("**")) {
            String[] split = uri.split("/");
            return split[split.length - 1];
        }
        String tmp = locationPattern.split("\\*\\*")[0];
        tmp = tmp.replace("file:", "").replace("url:", "").replace("classpath:", "").replace("classpath*:", "").replace("http:", "").replace("//", "/");
        return uri.split(tmp)[1];
    }

    private static String trim(String path) {
        if (path.contains("\\")) {
            path = path.replace("\\", "/");
        }
        if (path.contains("%5C")) {
            path = path.replace("%5C", "/");
        }
        return path;
    }

    public static String calculateLocalPathByDirectoryPath(String directoryPath, String uri) {
        String res;
        directoryPath = Node.trim(directoryPath);
        uri = Node.trim(uri);
        try {
            res = uri.split(directoryPath)[1];
            res = Node.trimLocalPath(res);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error while calculating localPath by directoryPath [%s] and uri [%s]", directoryPath, uri), e);
        }
        return res;
    }

    private static String trimLocalPath(String localPath) {
        if (localPath.startsWith("/")) {
            localPath = localPath.substring(1);
        }
        return localPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        return this.uri.equals(node.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "Node{localPath='" + this.localPath + "', absolutePath='" + this.uri + "'}";
    }
}

