/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.menu;

import net.n2oapp.framework.api.metadata.action.N2oOpenPage;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;

public class SimpleMenuValidator
extends TypedMetadataValidator<N2oSimpleMenu> {
    public Class<N2oSimpleMenu> getSourceClass() {
        return N2oSimpleMenu.class;
    }

    public void validate(N2oSimpleMenu simpleMenu, SourceProcessor p) {
        this.validateItems(simpleMenu.getMenuItems(), p);
    }

    private void validateDropdown(N2oSimpleMenu.DropdownMenuItem dropdownMenu, SourceProcessor p) {
        if (dropdownMenu.getName() == null) {
            throw new N2oMetadataValidationException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d 'name' \u0434\u043b\u044f <dropdown-menu>");
        }
        if (dropdownMenu.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(dropdownMenu.getDatasourceId(), p, String.format("<dropdown-menu name=%s> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(dropdownMenu.getName()), ValidationUtils.getIdOrEmptyString(dropdownMenu.getDatasourceId())));
        }
        this.validateItems(dropdownMenu.getMenuItems(), p);
    }

    private void validateMenuItem(N2oSimpleMenu.MenuItem menuItem, SourceProcessor p) {
        if (!(menuItem.getAction() instanceof N2oOpenPage) && menuItem.getName() == null) {
            throw new N2oMetadataValidationException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d 'name' \u0434\u043b\u044f <menu-item>");
        }
        if (menuItem.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(menuItem.getDatasourceId(), p, String.format("<menu-item name=%s> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(menuItem.getName()), ValidationUtils.getIdOrEmptyString(menuItem.getDatasourceId())));
        }
        if (ValidationUtils.isInvalidColor(menuItem.getBadgeColor())) {
            throw new N2oMetadataValidationException(String.format("<menu-item name=%s> \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 badge-color=\"%s\"", ValidationUtils.getIdOrEmptyString(menuItem.getName()), menuItem.getBadgeColor()));
        }
    }

    private void validateItems(N2oSimpleMenu.AbstractMenuItem[] items, SourceProcessor p) {
        p.safeStreamOf((Object[])items).forEach(i -> {
            if (i instanceof N2oSimpleMenu.MenuItem) {
                N2oSimpleMenu.MenuItem mi = (N2oSimpleMenu.MenuItem)i;
                this.validateMenuItem(mi, p);
            } else if (i instanceof N2oSimpleMenu.DropdownMenuItem) {
                N2oSimpleMenu.DropdownMenuItem mi = (N2oSimpleMenu.DropdownMenuItem)i;
                this.validateDropdown(mi, p);
            }
        });
    }
}

