/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.event;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.event.N2oOnChangeEvent;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class OnChangeEventValidator
extends TypedMetadataValidator<N2oOnChangeEvent> {
    public Class<? extends Source> getSourceClass() {
        return N2oOnChangeEvent.class;
    }

    public void validate(N2oOnChangeEvent source, SourceProcessor p) {
        if (source.getDatasourceId() == null) {
            throw new N2oMetadataValidationException("\u0412 \u0441\u043e\u0431\u044b\u0442\u0438\u0438 <on-change> \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'datasource'");
        }
        ValidationUtils.checkDatasourceExistence(source.getDatasourceId(), p, String.format("\u0421\u043e\u0431\u044b\u0442\u0438\u0435 <on-change> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", source.getDatasourceId()));
        if (ArrayUtils.isEmpty((Object[])source.getActions()) && source.getActionId() == null) {
            throw new N2oMetadataValidationException(String.format("\u0412 \u0441\u043e\u0431\u044b\u0442\u0438\u0438 <on-change> %s \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", ValidationUtils.getIdOrEmptyString(source.getId())));
        }
        ValidationUtils.checkOnFailAction(source.getActions());
    }
}

