/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget.chart;

import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.chart.N2oLineChart;
import net.n2oapp.framework.api.metadata.global.view.widget.chart.N2oLineChartItem;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.widget.chart.AbstractChartItem;
import net.n2oapp.framework.api.metadata.meta.widget.chart.ChartLineTypeEnum;
import net.n2oapp.framework.api.metadata.meta.widget.chart.ChartTypeEnum;
import net.n2oapp.framework.api.metadata.meta.widget.chart.LineChart;
import net.n2oapp.framework.api.metadata.meta.widget.chart.LineChartItem;
import net.n2oapp.framework.config.metadata.compile.widget.chart.StandardChartCompiler;
import org.springframework.stereotype.Component;

@Component
public class LineChartCompiler
extends StandardChartCompiler<LineChart, N2oLineChart> {
    public LineChart compile(N2oLineChart source, CompileContext<?, ?> context, CompileProcessor p) {
        LineChart chart = new LineChart();
        this.build(chart, source, p, Placeholders.property((String)"n2o.api.widget.chart.line.src"));
        chart.setType(ChartTypeEnum.LINE);
        for (N2oLineChartItem item : source.getItems()) {
            LineChartItem component = new LineChartItem();
            component.setFieldId(item.getFieldId());
            component.setLabel(item.getLabel());
            component.setType((ChartLineTypeEnum)CompileUtil.castDefault((Object)item.getType(), (Supplier[])new Supplier[]{() -> (ChartLineTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.widget.chart.line.type"), ChartLineTypeEnum.class)}));
            component.setColor(item.getColor());
            component.setHasLabel((Boolean)CompileUtil.castDefault((Object)item.getHasLabel(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.chart.line.has_label"), Boolean.class)}));
            chart.addItem((AbstractChartItem)component);
        }
        return this.compileStandardChart(chart, source, p);
    }

    public Class<? extends Source> getSourceClass() {
        return N2oLineChart.class;
    }
}

