/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import lombok.Generated;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oStandardDatasource;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.util.DatasourceUtil;

public class WidgetScope {
    private String widgetId;
    private String datasourceId;
    private String clientWidgetId;
    private String clientDatasourceId;
    private ReduxModelEnum model;
    private N2oStandardDatasource inLineDatasource;
    private MetaActions actions;

    public WidgetScope(String widgetId, String datasourceId, N2oStandardDatasource inLineDatasource) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.inLineDatasource = inLineDatasource;
    }

    public WidgetScope(String widgetId, String datasourceId, N2oStandardDatasource inLineDatasource, MetaActions actions) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.inLineDatasource = inLineDatasource;
        this.actions = actions;
    }

    public WidgetScope(String widgetId, String datasourceId, ReduxModelEnum model, CompileProcessor p) {
        this.widgetId = widgetId;
        this.datasourceId = datasourceId;
        this.model = model;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        this.clientWidgetId = pageScope != null ? DatasourceUtil.getClientWidgetId(widgetId, pageScope.getPageId()) : widgetId;
        this.clientDatasourceId = DatasourceUtil.getClientDatasourceId(datasourceId, p);
    }

    public WidgetScope(String widgetId, N2oStandardDatasource inLineDatasource, ReduxModelEnum model, CompileProcessor p, MetaActions actions) {
        this.widgetId = widgetId;
        this.inLineDatasource = inLineDatasource;
        this.model = model;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        this.clientWidgetId = pageScope != null ? DatasourceUtil.getClientWidgetId(widgetId, pageScope.getPageId()) : widgetId;
        this.clientDatasourceId = DatasourceUtil.getClientDatasourceId(this.datasourceId, p);
        this.actions = actions;
    }

    @Generated
    public String getWidgetId() {
        return this.widgetId;
    }

    @Generated
    public String getDatasourceId() {
        return this.datasourceId;
    }

    @Generated
    public String getClientWidgetId() {
        return this.clientWidgetId;
    }

    @Generated
    public String getClientDatasourceId() {
        return this.clientDatasourceId;
    }

    @Generated
    public ReduxModelEnum getModel() {
        return this.model;
    }

    @Generated
    public N2oStandardDatasource getInLineDatasource() {
        return this.inLineDatasource;
    }

    @Generated
    public MetaActions getActions() {
        return this.actions;
    }
}

