/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.fieldset;

import java.util.ArrayList;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.FieldsetItem;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetCol;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetRow;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class FieldSetRowCompiler
implements BaseSourceCompiler<FieldSet.Row, N2oFieldsetRow, CompileContext<?, ?>> {
    public FieldSet.Row compile(N2oFieldsetRow source, CompileContext<?, ?> context, CompileProcessor p) {
        FieldSet.Row row = new FieldSet.Row();
        row.setClassName(source.getCssClass());
        row.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        row.setProperties(p.mapAndResolveAttributes((ExtensionAttributesAware)source));
        if (source.getItems() != null) {
            ArrayList<FieldSet.Column> columns = new ArrayList<FieldSet.Column>();
            for (FieldsetItem item : source.getItems()) {
                if (item instanceof N2oFieldsetCol) {
                    columns.add((FieldSet.Column)p.compile((Object)item, context, new Object[0]));
                    continue;
                }
                N2oFieldsetCol newCol = new N2oFieldsetCol();
                newCol.setItems(new FieldsetItem[]{item});
                columns.add((FieldSet.Column)p.compile((Object)newCol, context, new Object[0]));
            }
            row.setCols(columns);
        }
        return row;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oFieldsetRow.class;
    }
}

