/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.datasource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.datasource.BrowserStorageTypeEnum;
import net.n2oapp.framework.api.metadata.datasource.CachedDatasource;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesModeEnum;
import net.n2oapp.framework.api.metadata.global.view.page.datasource.N2oCachedDatasource;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.datasource.BaseDatasourceCompiler;
import net.n2oapp.framework.config.metadata.compile.datasource.DatasourceCompileStaticProcessor;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class CachedDatasourceCompiler
extends BaseDatasourceCompiler<N2oCachedDatasource, CachedDatasource> {
    public Class<? extends Source> getSourceClass() {
        return N2oCachedDatasource.class;
    }

    public CachedDatasource compile(N2oCachedDatasource source, CompileContext<?, ?> context, CompileProcessor p) {
        CachedDatasource compiled = new CachedDatasource();
        this.compileDatasource(source, compiled, p);
        CompiledQuery query = DatasourceCompileStaticProcessor.initQuery(source.getQueryId(), p);
        CompiledObject object = DatasourceCompileStaticProcessor.initObject(source.getObjectId(), source.getQueryId(), p);
        compiled.setProvider(this.initDataProvider(compiled, source, context, p, query));
        compiled.setSubmit(this.initSubmit(source, compiled, object, context, p));
        compiled.setFetchOnInit((Boolean)CompileUtil.castDefault((Object)source.getFetchOnInit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.cached.fetch_on_init"), Boolean.class)}));
        return compiled;
    }

    private CachedDatasource.Provider initDataProvider(CachedDatasource compiled, N2oCachedDatasource source, CompileContext<?, ?> context, CompileProcessor p, CompiledQuery query) {
        CachedDatasource.Provider provider = new CachedDatasource.Provider();
        provider.setCacheExpires(source.getCacheExpires());
        provider.setKey((String)CompileUtil.castDefault((Object)source.getStorageKey(), (Object)source.getId(), (Object[])new String[0]));
        provider.setType("cached");
        provider.setStorage((BrowserStorageTypeEnum)CompileUtil.castDefault((Object)source.getStorageType(), (Supplier[])new Supplier[]{() -> (BrowserStorageTypeEnum)p.resolve(Placeholders.property((String)"n2o.api.datasource.cached.storage_type"), BrowserStorageTypeEnum.class)}));
        provider.setSize((Integer)CompileUtil.castDefault((Object)source.getSize(), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)"n2o.api.datasource.size"), Integer.class)}));
        String datasourceRoute = DatasourceCompileStaticProcessor.getDatasourceRoute(source.getId(), compiled.getId(), source.getRoute(), p);
        provider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + datasourceRoute);
        List<Filter> filters = DatasourceCompileStaticProcessor.initFilters(source.getId(), source.getFilters(), context, p, query);
        DatasourceCompileStaticProcessor.compileRoutes(source.getId(), compiled.getId(), filters, query, p);
        this.initDataProviderMappings(provider, filters, p);
        p.addRoute((CompileContext)DatasourceCompileStaticProcessor.getQueryContext(source.getId(), compiled.getId(), source.getQueryId(), source.getSize(), DefaultValuesModeEnum.QUERY, context, p, datasourceRoute, filters, query));
        return provider;
    }

    private void initDataProviderMappings(CachedDatasource.Provider dataProvider, List<Filter> filters, CompileProcessor p) {
        dataProvider.setPathMapping(new HashMap());
        dataProvider.setQueryMapping(new LinkedHashMap());
        ParentRouteScope parentRouteScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        if (parentRouteScope != null) {
            dataProvider.getPathMapping().putAll(parentRouteScope.getPathMapping());
            dataProvider.getQueryMapping().putAll(parentRouteScope.getQueryMapping());
        }
        if (filters != null) {
            List<String> params = RouteUtil.getParams(dataProvider.getUrl());
            filters.stream().filter(f -> params.contains(f.getParam())).forEach(f -> dataProvider.getPathMapping().put(f.getParam(), f.getLink()));
            filters.stream().filter(f -> !dataProvider.getPathMapping().containsKey(f.getParam())).forEach(f -> dataProvider.getQueryMapping().put(f.getParam(), f.getLink()));
        }
    }

    private CachedDatasource.Submit initSubmit(N2oCachedDatasource source, CachedDatasource compiled, CompiledObject compiledObject, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        N2oClientDataProvider submitProvider = DatasourceCompileStaticProcessor.initSubmit(source.getSubmit(), source.getId(), compiledObject, p);
        submitProvider.setClientDatasourceId(compiled.getId());
        submitProvider.setDatasourceId(source.getId());
        CachedDatasource.Submit submit = new CachedDatasource.Submit();
        DatasourceCompileStaticProcessor.compileSubmitClientDataProvider(submitProvider, (ClientDataProvider)submit, context, p);
        submit.setClearCache((Boolean)CompileUtil.castDefault((Object)source.getSubmit().getClearCacheAfterSubmit(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.datasource.cached.clear_cache_after_submit"), Boolean.class)}));
        submit.setKey(compiled.getProvider().getKey());
        submit.setModel(ReduxModelEnum.RESOLVE);
        submit.setStorage(compiled.getProvider().getStorage());
        return submit;
    }
}

