/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.Objects;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.control.Control;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;

public abstract class StandardFieldCompiler<D extends Control, S extends N2oStandardField>
extends FieldCompiler<StandardField<D>, S> {
    protected StandardField<D> compileStandardField(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, context, p);
        if (Objects.isNull(control.getSrc())) {
            control.setSrc(source.getSrc());
        }
        source.setSrc(null);
        source.setCopied((Boolean)CompileUtil.castDefault((Object)source.getCopied(), (Object)true, (Object[])new Boolean[0]));
        StandardField field = new StandardField();
        this.compileField(field, source, context, p);
        field.setControl(control);
        field.setClassName(null);
        this.initValidations(source, (Field)field, context, p);
        this.compileFilters(source, p);
        this.compileCopied(source, p);
        this.compileControl(control, source, p, field, context);
        control.setProperties(field.getProperties());
        field.setProperties(null);
        field.setDataProvider(this.initDataProvider(source, context, p));
        return field;
    }

    protected void compileControl(D control, S source, CompileProcessor p, StandardField<D> field, CompileContext<?, ?> context) {
        String src = (String)CompileUtil.castDefault((Object)control.getSrc(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)this.getControlSrcProperty()), String.class)});
        if (Objects.isNull(src)) {
            throw new N2oException("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'src'");
        }
        control.setSrc(src);
        control.setId(source.getId());
        control.setPlaceholder(p.resolveJS(source.getPlaceholder()));
        control.setClassName(p.resolveJS(source.getCssClass()));
        this.compileDefaultValues(field, source, context, p);
    }

    @Override
    protected String initLabel(S source, CompileProcessor p) {
        if (!"true".equals(source.getNoLabel())) {
            String label = p.resolveJS(source.getLabel());
            FieldSetScope scope = (FieldSetScope)p.getScope(FieldSetScope.class);
            if (Objects.isNull(label) && Objects.nonNull(scope)) {
                label = (String)scope.get(source.getId());
            }
            if (Objects.isNull(label)) {
                label = source.getId();
            }
            return label;
        }
        return null;
    }

    protected abstract String getControlSrcProperty();

    private ClientDataProvider initDataProvider(S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (Objects.isNull(source.getSubmit())) {
            return null;
        }
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromSubmit(source.getSubmit(), source.getId(), (CompiledObject)p.getScope(CompiledObject.class), p);
        dataProvider.setSubmitForm(Boolean.valueOf(false));
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (Objects.nonNull(widgetScope)) {
            dataProvider.getActionContextData().setParentWidgetId(widgetScope.getClientWidgetId());
            dataProvider.getActionContextData().setMessagesForm(widgetScope.getClientWidgetId());
        }
        ClientDataProvider clientDataProvider = ClientDataProviderUtil.compile(dataProvider, context, p);
        ParentRouteScope parentRouteScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        if (Objects.nonNull(parentRouteScope)) {
            clientDataProvider.getPathMapping().putAll(parentRouteScope.getPathMapping());
        }
        return clientDataProvider;
    }
}

