/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oCustomAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.meta.action.ActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.custom.CustomAction;
import net.n2oapp.framework.api.metadata.meta.action.custom.CustomActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.AsyncMetaSaga;
import net.n2oapp.framework.config.metadata.compile.N2oExtensionAttributeMapperFactory;
import net.n2oapp.framework.config.metadata.compile.action.AbstractMetaActionCompiler;
import net.n2oapp.framework.config.util.CompileUtil;
import org.jdom2.Namespace;
import org.springframework.stereotype.Component;

@Component
public class CustomActionCompiler
extends AbstractMetaActionCompiler<CustomAction, N2oCustomAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oCustomAction.class;
    }

    public CustomAction compile(N2oCustomAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, p);
        CustomAction customAction = new CustomAction();
        this.compileAction(customAction, source, p);
        customAction.setType(source.getType());
        customAction.setPayload((ActionPayload)this.initPayload(source, p));
        ((AsyncMetaSaga)customAction.getMeta()).setSuccess(this.initSuccessMeta(source, context, p));
        ((AsyncMetaSaga)customAction.getMeta()).setFail(this.initFailMeta(source, context));
        return customAction;
    }

    private CustomActionPayload initPayload(N2oCustomAction source, CompileProcessor p) {
        CustomActionPayload payload = new CustomActionPayload();
        N2oExtensionAttributeMapperFactory extensionAttributeMapperFactory = new N2oExtensionAttributeMapperFactory();
        if (source.getPayload() != null) {
            Map.of(new N2oNamespace(Namespace.NO_NAMESPACE), source.getPayload()).forEach((k, v) -> {
                Map resolved = v.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> p.resolveJS((String)v.get(key))));
                Map<String, Object> res = extensionAttributeMapperFactory.mapAttributes(resolved, k.getUri(), p);
                if (!(res = CompileUtil.resolveNestedAttributes(res, s -> s)).isEmpty()) {
                    payload.setAttributes(res);
                }
            });
        }
        return payload;
    }
}

