/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModelEnum;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.action.N2oAlertAction;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.ActionPayload;
import net.n2oapp.framework.api.metadata.meta.action.alert.AlertAction;
import net.n2oapp.framework.api.metadata.meta.action.alert.AlertActionPayload;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePlacementEnum;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class AlertActionCompiler
extends AbstractActionCompiler<AlertAction, N2oAlertAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oAlertAction.class;
    }

    public AlertAction compile(N2oAlertAction source, CompileContext<?, ?> context, CompileProcessor p) {
        this.initDefaults(source, p);
        AlertAction alertAction = new AlertAction();
        alertAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.alert.type"), String.class));
        this.compileAction(alertAction, source, p);
        alertAction.setPayload((ActionPayload)this.initPayload(source, p));
        return alertAction;
    }

    private AlertActionPayload initPayload(N2oAlertAction source, CompileProcessor p) {
        AlertActionPayload payload = new AlertActionPayload();
        payload.setKey((MessagePlacementEnum)CompileUtil.castDefault((Object)((MessagePlacementEnum)p.resolve(source.getPlacement(), MessagePlacementEnum.class)), (Supplier[])new Supplier[]{() -> (MessagePlacementEnum)p.resolve(Placeholders.property((String)"n2o.api.action.alert.placement"), MessagePlacementEnum.class)}));
        payload.setAlerts(this.initMessage(source, p));
        return payload;
    }

    private List<ResponseMessage> initMessage(N2oAlertAction source, CompileProcessor p) {
        ResponseMessage message = new ResponseMessage();
        message.setTitle(p.resolveJS(source.getTitle()));
        if (source.getText() != null) {
            message.setText(p.resolveJS(source.getText().trim()));
        }
        message.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        message.setClassName(source.getCssClass());
        message.setHref(StringUtils.hasLink((String)source.getHref()) ? p.resolveJS(source.getHref()) : RouteUtil.normalize(source.getHref()));
        message.setSeverity((String)CompileUtil.castDefault((Object)source.getColor(), (Supplier[])new Supplier[]{() -> (String)p.resolve(Placeholders.property((String)"n2o.api.action.alert.color"), String.class)}));
        message.setCloseButton((Boolean)CompileUtil.castDefault((Object)source.getCloseButton(), (Supplier[])new Supplier[]{() -> (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.alert.close_button"), Boolean.class)}));
        message.setPlacement((MessagePlacementEnum)CompileUtil.castDefault((Object)((MessagePlacementEnum)p.resolve(source.getPlacement(), MessagePlacementEnum.class)), (Supplier[])new Supplier[]{() -> (MessagePlacementEnum)p.resolve(Placeholders.property((String)"n2o.api.action.alert.placement"), MessagePlacementEnum.class)}));
        message.setTimeout((Integer)CompileUtil.castDefault((Object)((Integer)p.resolve(source.getTimeout(), Integer.class)), (Supplier[])new Supplier[]{() -> (Integer)p.resolve(Placeholders.property((String)String.format("n2o.api.message.%s.timeout", message.getSeverity())), Integer.class)}));
        message.setTime(this.initTimeStamp(source));
        if (StringUtils.isJs((Object)message.getText()) || StringUtils.isJs((Object)message.getTitle()) || StringUtils.isJs((Object)message.getHref())) {
            String datasourceId = (String)CompileUtil.castDefault((Object)source.getDatasourceId(), (Supplier[])new Supplier[]{() -> this.getLocalDatasourceId(p)});
            ReduxModelEnum reduxModel = (ReduxModelEnum)CompileUtil.castDefault((Object)source.getModel(), (Supplier[])new Supplier[]{() -> this.getLocalModel(p)});
            if (datasourceId == null) {
                throw new N2oException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \"<alert>\" \u0441\u043e \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u043c\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430\u043c\u0438");
            }
            message.setModelLink(new ModelLink(reduxModel, DatasourceUtil.getClientDatasourceId(datasourceId, p)).getLink());
        }
        return Collections.singletonList(message);
    }

    private LocalDateTime initTimeStamp(N2oAlertAction source) {
        if (source.getTime() == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(source.getTime());
        }
        catch (DateTimeParseException e) {
            throw new N2oException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b \u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u0432 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0435 'time', \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 ISO_LOCAL_DATE_TIME");
        }
    }
}

