/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.compile.SourceMerger;
import net.n2oapp.framework.api.metadata.compile.SourceMergerFactory;
import net.n2oapp.framework.config.factory.BaseMetadataFactory;
import net.n2oapp.framework.config.factory.FactoryPredicates;
import net.n2oapp.framework.config.metadata.compile.BaseSourceMerger;
import org.springframework.core.GenericTypeResolver;

public class N2oSourceMergerFactory
extends BaseMetadataFactory<SourceMerger<?>>
implements SourceMergerFactory {
    public N2oSourceMergerFactory() {
    }

    public N2oSourceMergerFactory(Map<String, SourceMerger<?>> beans) {
        super(beans);
    }

    public <S> S merge(S ref, S source) {
        List<SourceMerger> mergers = this.produceList(FactoryPredicates::isSourceAssignableFrom, ref);
        for (SourceMerger merger : mergers) {
            SourceMerger castedMerger = merger;
            Class<?> mergerClass = this.getMergerClass(castedMerger);
            if (mergerClass == null || !mergerClass.isAssignableFrom(source.getClass())) continue;
            source = castedMerger.merge(ref, source);
        }
        return source;
    }

    private Class<?> getMergerClass(SourceMerger<?> merger) {
        return GenericTypeResolver.resolveTypeArgument((Class)merger.getClass(), BaseSourceMerger.class);
    }
}

