/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.N2oEnum;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.ExtensionAttributeMapperFactory;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.pipeline.BindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.metadata.compile.DataModel;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;
import net.n2oapp.framework.config.util.StylesResolver;

public class N2oCompileProcessor
implements CompileProcessor,
BindProcessor,
SourceProcessor {
    private static final PlaceHoldersResolver LINK_RESOLVER = new PlaceHoldersResolver("{", "}");
    private static final PlaceHoldersResolver URL_RESOLVER = new PlaceHoldersResolver(":", "", Boolean.valueOf(true));
    private static final Pattern FIELD_ID_PATTERN = Pattern.compile("[a-zA-Z_][\\w.\\[\\]*]*");
    private MetadataEnvironment env;
    private SubModelsProcessor subModelsProcessor;
    private Map<Class<?>, Object> scope = Collections.emptyMap();
    private CompileContext<?, ?> context;
    private DataSet params;
    private DataModel model;
    private CompileModeEnum mode = CompileModeEnum.READ;
    private BindTerminalPipeline bindPipeline;
    private CompileTerminalPipeline<?> compilePipeline;
    private ReadCompileTerminalPipeline<?> readCompilePipeline;
    private ReadTerminalPipeline<?> readPipeline;
    private Set<String> forbiddenIds;

    public N2oCompileProcessor(MetadataEnvironment env) {
        this.env = env;
        N2oPipelineSupport pipelineSupport = new N2oPipelineSupport(env);
        this.bindPipeline = (BindTerminalPipeline)env.getBindPipelineFunction().apply((Object)pipelineSupport);
        this.readPipeline = (ReadTerminalPipeline)env.getReadPipelineFunction().apply((Object)pipelineSupport);
        this.readCompilePipeline = (ReadCompileTerminalPipeline)env.getReadCompilePipelineFunction().apply((Object)pipelineSupport);
        this.compilePipeline = (CompileTerminalPipeline)env.getCompilePipelineFunction().apply((Object)pipelineSupport);
        this.forbiddenIds = (Set)env.getSystemProperties().getProperty("n2o.config.field.forbidden_ids", Set.class);
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params) {
        this(env);
        this.mode = CompileModeEnum.COMPILE;
        this.context = context;
        this.params = params;
        this.model = new DataModel();
        this.model.addAll(context.getQueryRouteMapping(), params);
        this.model.addAll(context.getPathRouteMapping(), params);
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params, Object ... scopes) {
        this(env, context, params);
        Object[] flattedScopes = this.flatScopes(scopes);
        this.scope = new HashMap();
        Stream.of(Optional.ofNullable(flattedScopes).orElse(new Compiled[0])).filter(Objects::nonNull).forEach(s -> this.scope.put(s.getClass(), s));
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params, SubModelsProcessor subModelsProcessor, Object ... scopes) {
        this(env);
        this.mode = CompileModeEnum.BIND;
        this.context = context;
        this.params = params;
        this.subModelsProcessor = subModelsProcessor;
        this.model = new DataModel();
        this.model.addAll(context.getQueryRouteMapping(), params);
        this.model.addAll(context.getPathRouteMapping(), params);
        Object[] flattedScopes = this.flatScopes(scopes);
        this.scope = new HashMap();
        Stream.of(Optional.ofNullable(flattedScopes).orElse(new Compiled[0])).filter(Objects::nonNull).forEach(s -> this.scope.put(s.getClass(), s));
    }

    private N2oCompileProcessor(N2oCompileProcessor parent, Object ... scopes) {
        this.env = parent.env;
        this.mode = parent.mode;
        this.scope = new HashMap(parent.scope);
        Stream.of(Optional.ofNullable(scopes).orElse(new Compiled[0])).filter(Objects::nonNull).forEach(s -> this.scope.put(s.getClass(), s));
        this.readPipeline = parent.readPipeline;
        this.readCompilePipeline = parent.readCompilePipeline;
        this.compilePipeline = parent.compilePipeline;
        this.params = parent.params;
        this.context = parent.context;
        this.forbiddenIds = parent.forbiddenIds;
    }

    public <D extends Compiled, S> D compile(S source, CompileContext<?, ?> context, Object ... scopes) {
        Object[] flattedScopes = this.flatScopes(scopes);
        return (D)this.compilePipeline.get(source, context, (CompileProcessor)new N2oCompileProcessor(this, flattedScopes));
    }

    public <D extends Compiled> void bind(D compiled, Object ... scopes) {
        Object[] flattedScopes = this.flatScopes(scopes);
        if (compiled != null) {
            this.bindPipeline.get(compiled, this.context, this.params, this.subModelsProcessor, flattedScopes);
        }
    }

    public Map<String, Object> mapAttributes(ExtensionAttributesAware source) {
        if (source.getExtAttributes() == null || source.getExtAttributes().isEmpty()) {
            return null;
        }
        ExtensionAttributeMapperFactory extensionAttributeMapperFactory = this.env.getExtensionAttributeMapperFactory();
        HashMap<String, Object> extAttributes = new HashMap<String, Object>();
        source.getExtAttributes().forEach((k, v) -> {
            Map<String, Object> res = extensionAttributeMapperFactory.mapAttributes(v, k.getUri(), (CompileProcessor)this);
            if (!(res = CompileUtil.resolveNestedAttributes(res, arg_0 -> ((DomainProcessor)this.env.getDomainProcessor()).deserialize(arg_0))).isEmpty()) {
                extAttributes.putAll(res);
            }
        });
        return extAttributes;
    }

    public Map<String, Object> mapAndResolveAttributes(ExtensionAttributesAware source) {
        if (source.getExtAttributes() == null || source.getExtAttributes().isEmpty()) {
            return null;
        }
        HashMap<N2oNamespace, Map<String, String>> resolved = new HashMap<N2oNamespace, Map<String, String>>();
        for (Map.Entry entry : source.getExtAttributes().entrySet()) {
            resolved.put((N2oNamespace)entry.getKey(), ((Map)entry.getValue()).keySet().stream().collect(Collectors.toMap(k -> k, k -> this.resolveJS((String)((Map)entry.getValue()).get(k)))));
        }
        source.setExtAttributes(resolved);
        return this.mapAttributes(source);
    }

    public CompileContext<?, ?> getContext() {
        return this.context;
    }

    public <D extends Compiled> D getCompiled(CompileContext<D, ?> context) {
        return (D)this.readCompilePipeline.get(context, (CompileProcessor)new N2oCompileProcessor(this, new Object[0]));
    }

    public <D> D getScope(Class<D> scopeClass) {
        return (D)this.scope.get(scopeClass);
    }

    public <S extends SourceMetadata> S getSource(String id, Class<S> sourceClass) {
        return (S)this.readPipeline.get(id, sourceClass);
    }

    public <S extends SourceMetadata> S getSource(String id, Class<S> sourceClass, CompileProcessor processor) {
        return (S)this.readPipeline.get(id, sourceClass, (SourceProcessor)new N2oCompileProcessor((N2oCompileProcessor)processor, new Object[0]));
    }

    public <D extends Compiled> void addRoute(CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(context.getRoute((BindProcessor)this), context);
    }

    public <D extends Compiled> void addRoute(String route, CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(route, context);
    }

    public <T> T resolve(String placeholder, Class<T> clazz) {
        Object value = this.resolveProperty(placeholder, true);
        value = this.resolveContext(value);
        if (N2oEnum.class.isAssignableFrom(clazz)) {
            value = StylesResolver.camelToSnake(value);
        }
        return (T)this.env.getDomainProcessor().deserialize(value, clazz);
    }

    public Object resolve(String placeholder, String domain) {
        Object value = this.resolveProperty(placeholder, true);
        value = this.resolveContext(value);
        return this.env.getDomainProcessor().deserialize(value, domain);
    }

    public Object resolve(String placeholder) {
        Object value = this.resolveProperty(placeholder, false);
        value = this.resolveContext(value);
        return this.env.getDomainProcessor().deserialize(value);
    }

    public Object resolve(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return this.resolve(str);
        }
        return value;
    }

    public <T> T resolve(Object value, Class<T> clazz) {
        if (value instanceof String) {
            String str = (String)value;
            return this.resolve(str, clazz);
        }
        return (T)value;
    }

    public String resolveText(String text) {
        if (StringUtils.hasProperty((String)text)) {
            return this.env.getSystemProperties().resolvePlaceholders(text);
        }
        if (StringUtils.hasContext((String)text)) {
            return this.env.getContextProcessor().resolveText(text);
        }
        return text;
    }

    public String getMessage(String messageCode, Object ... arguments) {
        String defaultMessage = messageCode.contains("{0}") ? MessageFormat.format(messageCode, arguments) : messageCode;
        return this.env.getMessageSource().getMessage(messageCode, arguments, defaultMessage);
    }

    public <S extends Source> S merge(S ref, S source) {
        return (S)((Source)this.env.getSourceMergerFactory().merge(ref, source));
    }

    public String getExternalFile(String fileUri) {
        return this.env.getExternalFilesLoader().getContentByUri(fileUri);
    }

    public boolean canResolveParam(String param) {
        return this.params != null && !this.params.isEmpty() && this.params.containsKey((Object)param);
    }

    public Object resolveJS(String text, Class<?> clazz) {
        String value = ScriptProcessor.resolveLinks((String)text);
        return this.env.getDomainProcessor().deserialize((Object)value, clazz);
    }

    public String resolveUrl(String url) {
        return URL_RESOLVER.resolve(url, (Object)this.params);
    }

    public String resolveUrl(String url, Map<String, ? extends BindLink> pathMappings, Map<String, ? extends BindLink> queryMappings) {
        String resultUrl = url;
        if (pathMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(pathMappings, (String)k));
        }
        if (queryMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(queryMappings, (String)k));
        }
        resultUrl = URL_RESOLVER.resolve(resultUrl, k -> pathMappings != null && pathMappings.containsKey(k) || queryMappings != null && queryMappings.containsKey(k) || this.params == null ? null : this.params.get(k));
        return resultUrl;
    }

    public String resolveUrl(String url, ModelLink link) {
        List<String> paramNames = RouteUtil.getParams(url);
        if (paramNames.isEmpty() || this.params == null) {
            return url;
        }
        HashMap<String, String> valueParamMap = new HashMap<String, String>();
        this.collectModelLinks(this.context.getPathRouteMapping(), link.getWidgetLink(), valueParamMap);
        this.collectModelLinks(this.context.getQueryRouteMapping(), link.getWidgetLink(), valueParamMap);
        for (String param : paramNames) {
            if (!valueParamMap.containsKey(param) || !this.params.containsKey(valueParamMap.get(param))) continue;
            url = url.replace(":" + param, this.params.get(valueParamMap.get(param)).toString());
        }
        return url;
    }

    public String resolveUrl(String url, List<ModelLink> links) {
        List<String> paramNames = RouteUtil.getParams(url);
        if (paramNames.isEmpty() || this.params == null) {
            return url;
        }
        HashMap<String, String> valueParamMap = new HashMap<String, String>();
        for (ModelLink link : links) {
            this.collectModelLinks(this.context.getPathRouteMapping(), link.getWidgetLink(), valueParamMap);
            this.collectModelLinks(this.context.getQueryRouteMapping(), link.getWidgetLink(), valueParamMap);
        }
        for (String param : paramNames) {
            if (!valueParamMap.containsKey(param) || !this.params.containsKey(valueParamMap.get(param))) continue;
            url = url.replace(":" + param, this.params.get(valueParamMap.get(param)).toString());
        }
        return url;
    }

    public BindLink resolveLink(BindLink link, boolean observable) {
        return this.resolveLink(link, observable, true);
    }

    public BindLink resolveLink(BindLink link, boolean observable, boolean strongCompare) {
        ModelLink modelLink;
        if (link == null) {
            return null;
        }
        Optional<String> res = Optional.empty();
        if (this.context != null) {
            res = strongCompare ? this.getValueIfPossible(res, kv -> ((ModelLink)kv.getValue()).equalsNormalizedLink((Object)link)) : this.getValueIfPossible(res, kv -> ((ModelLink)kv.getValue()).equalsLink((Object)link));
        }
        Object value = null;
        if (res.isPresent()) {
            value = this.params.get((Object)res.get());
        } else if (link instanceof ModelLink && (modelLink = (ModelLink)link).getParam() != null && (observable || !modelLink.isObserve())) {
            value = this.params.get((Object)modelLink.getParam());
        }
        if (value == null) {
            return link;
        }
        return this.createLink(link, value);
    }

    private Optional<String> getValueIfPossible(Optional<String> res, Predicate<Map.Entry<String, ModelLink>> filter) {
        if (this.context.getQueryRouteMapping() != null) {
            res = this.context.getQueryRouteMapping().entrySet().stream().filter(filter).map(Map.Entry::getKey).findAny();
        }
        if (res.isEmpty() && this.context.getPathRouteMapping() != null) {
            res = this.context.getPathRouteMapping().entrySet().stream().filter(filter).map(Map.Entry::getKey).findAny();
        }
        return res;
    }

    public Object resolveLinkValue(ModelLink link) {
        return link.getParam() != null ? this.params.get((Object)link.getParam()) : null;
    }

    private BindLink createLink(BindLink link, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            value = this.resolveText(str);
        }
        if (value != null) {
            BindLink resultLink;
            if (link instanceof ModelLink) {
                ModelLink modelLink = (ModelLink)link;
                resultLink = new ModelLink(modelLink);
                ((ModelLink)resultLink).setObserve(false);
            } else {
                resultLink = new BindLink(link.getLink());
            }
            resultLink.setValue(value);
            return resultLink;
        }
        return null;
    }

    public ModelLink resolveSubModels(ModelLink link) {
        DataSet dataSet;
        if (link == null) {
            return null;
        }
        if (link.getSubModelQuery() == null) {
            return link;
        }
        if (link.getValue() == null) {
            return link;
        }
        if (link.getValue() instanceof Collection) {
            if (!link.getSubModelQuery().isMulti()) {
                throw new N2oException("Sub model [" + link.getSubModelQuery().getFullName() + "] must be multi for value " + String.valueOf(link.getValue()));
            }
            ArrayList<DataSet> dataList = new ArrayList<DataSet>();
            for (Object o : (List)link.getValue()) {
                if (o instanceof DefaultValues) {
                    DefaultValues defaultValues = (DefaultValues)o;
                    dataList.add(new DataSet(defaultValues.getValues()));
                    continue;
                }
                dataList.add(new DataSet("id", o));
            }
            DataSet dataSet2 = new DataSet(link.getSubModelQuery().getSubModel(), dataList);
            if (this.subModelsProcessor != null) {
                this.subModelsProcessor.executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet2);
            }
            ModelLink resolvedLink = link.getSubModelLink();
            List valueList = (List)dataSet2.get((Object)link.getSubModelQuery().getSubModel());
            resolvedLink.setValue(valueList.stream().map(DefaultValues::new).toList());
            return resolvedLink;
        }
        Object dataList = link.getValue();
        if (dataList instanceof DefaultValues) {
            DefaultValues defaultValues = (DefaultValues)dataList;
            if (link.getSubModelQuery().isMulti()) {
                throw new N2oException("Sub model [" + link.getSubModelQuery().getSubModel() + "] must not be multi for value " + String.valueOf(link.getValue()));
            }
            dataSet = new DataSet();
            dataSet.put(link.getSubModelQuery().getSubModel(), (Object)defaultValues.getValues());
            if (this.subModelsProcessor != null) {
                this.subModelsProcessor.executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
            }
            ModelLink resolvedLink = link.getSubModelLink();
            resolvedLink.setValue((Object)new DefaultValues((Map)dataSet.get((Object)link.getSubModelQuery().getSubModel())));
            return resolvedLink;
        }
        dataSet = new DataSet();
        if (link.getSubModelQuery().isMulti()) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            list.add(new DataSet("id", link.getValue()));
            dataSet.put(link.getSubModelQuery().getSubModel(), list);
        } else {
            dataSet.put(link.getSubModelQuery().getSubModel() + ".id", link.getValue());
        }
        if (this.subModelsProcessor != null) {
            this.subModelsProcessor.executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
        }
        ModelLink resolvedLink = link.getSubModelLink();
        if (link.getSubModelQuery().isMulti()) {
            List valueList = (List)dataSet.get((Object)link.getSubModelQuery().getSubModel());
            resolvedLink.setValue(valueList.stream().map(DefaultValues::new).toList());
        } else {
            resolvedLink.setValue((Object)new DefaultValues((Map)dataSet.get((Object)link.getSubModelQuery().getSubModel())));
        }
        return resolvedLink;
    }

    public DataSet executeQuery(String queryId) {
        if (this.subModelsProcessor == null) {
            return null;
        }
        return (DataSet)this.subModelsProcessor.getQueryResult(queryId, this.params).getCollection().get(0);
    }

    public String resolveText(String text, ModelLink link) {
        String resolved = this.resolveText(text);
        if (link != null) {
            return LINK_RESOLVER.resolve(resolved, this.model.getDataIfAbsent(link, this.subModelsProcessor));
        }
        return resolved;
    }

    public String resolveText(String text, List<ModelLink> links) {
        String resolved = this.resolveText(text);
        if (links != null && !links.isEmpty()) {
            for (ModelLink link : links) {
                resolved = LINK_RESOLVER.resolve(resolved, this.model.getDataIfAbsent(link, this.subModelsProcessor));
            }
        }
        return resolved;
    }

    public String resolveTextWithQuotes(String text) {
        return this.env.getContextProcessor().resolveTextWithQuotes(text);
    }

    public String resolveTextByParams(String text) {
        if (LINK_RESOLVER.hasPlaceHolders(text)) {
            return LINK_RESOLVER.resolve(text, ps -> this.params.get(ps));
        }
        return text;
    }

    public <T extends Source> void validate(T metadata, Object ... scope) {
        if (metadata == null) {
            return;
        }
        this.env.getSourceValidatorFactory().validate(metadata, (SourceProcessor)new N2oCompileProcessor(this, scope));
    }

    public <T extends SourceMetadata> T getOrThrow(String id, Class<T> metadataClass) {
        if (id == null) {
            return null;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            return null;
        }
        return this.getSource(id, metadataClass);
    }

    public <T extends SourceMetadata> void checkForExists(String id, Class<T> metadataClass, String errorMessage) {
        if (id == null) {
            return;
        }
        if (StringUtils.hasWildcard((String)id) || StringUtils.hasLink((String)id)) {
            return;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            throw new N2oMetadataValidationException(errorMessage);
        }
    }

    public void checkId(IdAware metadata, String errorMessage) {
        if (metadata == null || metadata.getId() == null) {
            return;
        }
        Matcher matcher = FIELD_ID_PATTERN.matcher(metadata.getId());
        if (!matcher.matches() || this.forbiddenIds.contains(metadata.getId())) {
            throw new N2oMetadataValidationException(String.format(errorMessage, metadata.getId()));
        }
    }

    private Object resolveProperty(Object placeholder, boolean strong) {
        if (!(placeholder instanceof String)) {
            return placeholder;
        }
        String placeholderStr = (String)placeholder;
        Object value = placeholder;
        if (StringUtils.isProperty((String)placeholderStr)) {
            value = strong ? this.env.getSystemProperties().resolveRequiredPlaceholders(placeholderStr) : this.env.getSystemProperties().resolvePlaceholders(placeholderStr);
        }
        return value;
    }

    private Object resolveContext(Object placeholder) {
        if (!(placeholder instanceof String)) {
            return placeholder;
        }
        String placeholderStr = (String)placeholder;
        Object value = placeholder;
        if (this.isBinding() && StringUtils.isContext((String)placeholderStr)) {
            value = this.env.getContextProcessor().resolve(placeholder);
        }
        return value;
    }

    private void collectModelLinks(Map<String, ModelLink> linkMap, ModelLink link, Map<String, String> resultMap) {
        if (linkMap != null) {
            linkMap.forEach((k, v) -> {
                if (v.equalsLink((Object)link)) {
                    resultMap.put((String)k, (String)k);
                    resultMap.put(v.getFieldId(), (String)k);
                }
            });
        }
    }

    private Object getValue(Map<String, ? extends BindLink> mapping, String key) {
        if (!mapping.containsKey(key)) {
            return null;
        }
        BindLink bindLink = mapping.get(key);
        if (bindLink instanceof ModelLink) {
            ModelLink modelLink = (ModelLink)bindLink;
            Object value = this.model.getValue(modelLink);
            if (value != null) {
                mapping.remove(key);
            }
            return value;
        }
        return null;
    }

    private Object[] flatScopes(Object[] scopes) {
        if (scopes != null && Stream.of(scopes).filter(Objects::nonNull).anyMatch(o -> o.getClass().isArray())) {
            return this.flatScopes(Stream.of(scopes).filter(Objects::nonNull).flatMap(o -> o.getClass().isArray() ? Arrays.stream((Object[])o) : Stream.of(o)).filter(Objects::nonNull).toArray());
        }
        return scopes;
    }

    private boolean isBinding() {
        return this.mode.equals((Object)CompileModeEnum.BIND);
    }

    static enum CompileModeEnum {
        READ,
        COMPILE,
        BIND;

    }
}

