/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.pipeline.PersistPipeline;
import net.n2oapp.framework.api.metadata.pipeline.PersistTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationTypeEnum;
import net.n2oapp.framework.config.compile.pipeline.DummyCompileContext;
import net.n2oapp.framework.config.compile.pipeline.N2oPipeline;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.apache.commons.io.IOUtils;

public class N2oPersistPipeline
extends N2oPipeline
implements PersistPipeline {
    public N2oPersistPipeline(MetadataEnvironment env) {
        super(env);
    }

    public PersistTerminalPipeline persist() {
        this.pullOp(PipelineOperationTypeEnum.PERSIST);
        return new PersistTerminalPipeline(){

            public <S extends SourceMetadata> InputStream get(S input) {
                return (InputStream)N2oPersistPipeline.this.execute(new DummyCompileContext(input.getId(), input.getSourceBaseClass()), null, input);
            }

            public <S extends SourceMetadata> void set(S input, OutputStream output) {
                try (InputStream is = this.get(input);){
                    IOUtils.copy((InputStream)is, (OutputStream)output);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            public <S extends SourceMetadata> void set(S input, String directory) {
                String path = PathUtil.concatFileNameAndBasePath(input.getId() + "." + input.getMetadataType() + ".xml", directory);
                FileSystemUtil.saveContentToFile(this.get(input), new File(path));
            }
        };
    }

    public PersistPipeline validate() {
        this.pullOp(PipelineOperationTypeEnum.VALIDATE);
        return this;
    }

    public PersistPipeline merge() {
        this.pullOp(PipelineOperationTypeEnum.MERGE);
        return this;
    }

    public PersistPipeline transform() {
        this.pullOp(PipelineOperationTypeEnum.SOURCE_TRANSFORM);
        return this;
    }

    public PersistPipeline cache() {
        this.pullOp(PipelineOperationTypeEnum.SOURCE_CACHE);
        return this;
    }

    public PersistPipeline copy() {
        this.pullOp(PipelineOperationTypeEnum.COPY);
        return this;
    }
}

