/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.Submit;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.query.N2oQuery;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePlacement;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePosition;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.DatasourceUtil;
import net.n2oapp.framework.config.util.QueryContextUtil;

public class N2oClientDataProviderUtil {
    private N2oClientDataProviderUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static N2oClientDataProvider initFromField(N2oPreFilter[] preFilters, String queryId, CompileProcessor p) {
        QueryContext queryContext = new QueryContext(queryId);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        p.addRoute((CompileContext)QueryContextUtil.prepareQueryContextForRouteRegister(query));
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        if (widgetScope != null) {
            dataProvider.setTargetModel(widgetScope.getModel());
            dataProvider.setClientDatasourceId(widgetScope.getClientDatasourceId());
        }
        dataProvider.setUrl(query.getRoute());
        if (preFilters != null) {
            N2oParam[] queryParams = new N2oParam[preFilters.length];
            for (int i = 0; i < preFilters.length; ++i) {
                N2oPreFilter preFilter = preFilters[i];
                N2oQuery.Filter filter = query.getFilterByPreFilter(preFilter);
                if (filter == null) {
                    throw new N2oException(String.format("Filter for field %s is not found in the query %s", preFilter.getFieldId(), queryId));
                }
                N2oParam queryParam = new N2oParam();
                queryParam.setName((String)query.getFilterIdToParamMap().get(filter.getFilterId()));
                queryParam.setRequired(preFilter.getRequired());
                if (preFilter.getParam() == null) {
                    queryParam.setValueList(N2oClientDataProviderUtil.getPrefilterValue(preFilter));
                    queryParam.setModel(preFilter.getModel());
                    queryParam.setDatasourceId(preFilter.getDatasourceId());
                    if (queryParam.getDatasourceId() == null && preFilter.getRefWidgetId() != null) {
                        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                        queryParam.setDatasourceId(pageScope.getWidgetIdSourceDatasourceMap().get(preFilter.getRefWidgetId()));
                    }
                } else {
                    queryParam.setValueParam(preFilter.getParam());
                }
                queryParams[i] = queryParam;
            }
            dataProvider.setQueryParams(queryParams);
        }
        return dataProvider;
    }

    public static N2oClientDataProvider initFromSubmit(Submit submit, String fieldId, CompiledObject compiledObject, CompileProcessor p) {
        if (compiledObject == null) {
            throw new N2oException(String.format("For compilation submit for field [%s] is necessary object!", fieldId));
        }
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        dataProvider.setMethod(RequestMethod.POST);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        dataProvider.setUrl((String)CompileUtil.castDefault((Object)submit.getRoute(), (Supplier[])new Supplier[]{() -> widgetScope.getDatasourceId() + "_" + fieldId}));
        dataProvider.setTargetModel(widgetScope.getModel());
        dataProvider.setClientDatasourceId(widgetScope.getClientDatasourceId());
        dataProvider.setPathParams(submit.getPathParams());
        dataProvider.setHeaderParams(submit.getHeaderParams());
        dataProvider.setFormParams(submit.getFormParams());
        N2oClientDataProvider.ActionContextData actionContextData = new N2oClientDataProvider.ActionContextData();
        actionContextData.setObjectId(compiledObject.getId());
        actionContextData.setOperationId(submit.getOperationId());
        actionContextData.setRoute(submit.getRoute());
        actionContextData.setMessageOnSuccess(((Boolean)CompileUtil.castDefault((Object)submit.getMessageOnSuccess(), (Object)false, (Object[])new Boolean[0])).booleanValue());
        actionContextData.setMessageOnFail(((Boolean)CompileUtil.castDefault((Object)submit.getMessageOnFail(), (Object)false, (Object[])new Boolean[0])).booleanValue());
        actionContextData.setMessagePosition((MessagePosition)CompileUtil.castDefault((Object)submit.getMessagePosition(), (Supplier[])new Supplier[]{() -> (MessagePosition)p.resolve(Placeholders.property((String)"n2o.api.message.position"), MessagePosition.class)}));
        actionContextData.setMessagePlacement((MessagePlacement)CompileUtil.castDefault((Object)submit.getMessagePlacement(), (Supplier[])new Supplier[]{() -> (MessagePlacement)p.resolve(Placeholders.property((String)"n2o.api.message.placement"), MessagePlacement.class)}));
        actionContextData.setMessagesForm(submit.getMessageWidgetId());
        actionContextData.setOperation((CompiledObject.Operation)compiledObject.getOperations().get(submit.getOperationId()));
        if (Boolean.TRUE.equals(submit.getRefreshOnSuccess())) {
            actionContextData.setRefresh(new RefreshSaga());
            if (submit.getRefreshDatasourceIds() != null) {
                actionContextData.getRefresh().setDatasources(DatasourceUtil.getClientDatasourceIds(Arrays.asList(submit.getRefreshDatasourceIds()), p));
            } else if (widgetScope.getClientDatasourceId() != null) {
                actionContextData.getRefresh().setDatasources(Collections.singletonList(widgetScope.getClientDatasourceId()));
            }
        }
        dataProvider.setActionContextData(actionContextData);
        return dataProvider;
    }

    private static Object getPrefilterValue(N2oPreFilter n2oPreFilter) {
        if (n2oPreFilter.getValues() == null) {
            return ScriptProcessor.resolveExpression((String)n2oPreFilter.getValue());
        }
        return ScriptProcessor.resolveArrayExpression((String[])n2oPreFilter.getValues());
    }
}

