/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.factory.MetadataFactory;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.api.register.scan.MetadataScannerFactory;
import net.n2oapp.framework.config.factory.AwareFactorySupport;
import net.n2oapp.framework.config.register.scanner.DefaultInfoScanner;
import net.n2oapp.framework.config.register.scanner.OverrideInfoScanner;

public class N2oMetadataScannerFactory
implements MetadataFactory<MetadataScanner>,
MetadataScannerFactory,
MetadataEnvironmentAware {
    private LinkedList<MetadataScanner> scanners;

    public N2oMetadataScannerFactory() {
        this.scanners = new LinkedList();
    }

    public N2oMetadataScannerFactory(Map<String, MetadataScanner> scanners) {
        ArrayList<MetadataScanner> scannersList = new ArrayList<MetadataScanner>(OverrideBean.removeOverriddenBeans(scanners).values());
        this.scanners = this.getSortedScanners(scannersList);
    }

    public List<? extends SourceInfo> scan() {
        ArrayList infoList = new ArrayList();
        for (MetadataScanner scanner : this.scanners) {
            infoList.addAll(scanner.scan());
        }
        return infoList;
    }

    private LinkedList<MetadataScanner> getSortedScanners(List<MetadataScanner> allScaners) {
        if (allScaners == null || allScaners.isEmpty()) {
            return new LinkedList<MetadataScanner>();
        }
        LinkedList<MetadataScanner> sorted = new LinkedList<MetadataScanner>();
        ArrayList<OverrideInfoScanner> overrideInfoScanners = new ArrayList<OverrideInfoScanner>();
        for (MetadataScanner scanner : allScaners) {
            if (scanner instanceof OverrideInfoScanner) {
                overrideInfoScanners.add((OverrideInfoScanner)scanner);
                continue;
            }
            if (scanner instanceof DefaultInfoScanner) {
                sorted.addFirst(scanner);
                continue;
            }
            sorted.addLast(scanner);
        }
        overrideInfoScanners.forEach(s -> sorted.addLast((MetadataScanner)s));
        return sorted;
    }

    public N2oMetadataScannerFactory add(MetadataScanner ... scanners) {
        if (scanners == null) {
            return this;
        }
        ArrayList<MetadataScanner> allScanners = new ArrayList<MetadataScanner>();
        allScanners.addAll(Arrays.asList(scanners));
        allScanners.addAll(this.scanners);
        this.scanners = this.getSortedScanners(allScanners);
        return this;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.scanners.forEach(o -> AwareFactorySupport.enrich(o, environment));
    }
}

