/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.config.reader.XmlMetadataLoader;
import net.n2oapp.framework.config.register.ConfigId;
import net.n2oapp.framework.config.register.FileInfo;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.Origin;
import net.n2oapp.framework.config.register.storage.PathUtil;

public class XmlInfo
extends FileInfo {
    protected boolean override;
    private Class<? extends MetadataScanner> scannerClass;
    @Deprecated
    protected ConfigId configId;
    protected Set<ConfigId> dependents = new HashSet<ConfigId>();
    @Deprecated
    protected Origin origin = Origin.xml;
    protected XmlInfo ancestor;

    @Deprecated
    protected XmlInfo() {
    }

    public XmlInfo(String id, Class<? extends SourceMetadata> baseSourceClass, String localPath, String configPath) {
        this.id = id;
        this.baseSourceClass = baseSourceClass;
        this.localPath = localPath;
        this.uri = PathUtil.concatAbsoluteAndLocalPath(configPath, localPath);
    }

    public XmlInfo(String id, Class<? extends SourceMetadata> baseSourceClass, String localPath) {
        this(id, baseSourceClass, localPath, "");
    }

    @Deprecated
    public XmlInfo(InfoConstructor constructor) {
        this.id = constructor.getId();
        this.baseSourceClass = constructor.getBaseSourceClass();
        this.uri = constructor.getUri();
        this.localPath = constructor.getLocalPath();
        this.configId = constructor.getConfigId();
        this.dependents = Collections.unmodifiableSet(constructor.getDependents());
        this.origin = constructor.getOrigin();
        this.ancestor = constructor.getAncestor();
    }

    @Deprecated
    public XmlInfo(ConfigId configId) {
        this.id = configId.getId();
        this.baseSourceClass = configId.getBaseSourceClass();
        this.configId = configId;
    }

    public String getType() {
        return this.configId.getType();
    }

    @Deprecated
    public static Class getClass(String cacheKey) {
        try {
            return Class.forName(cacheKey.split("\\$")[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getId(String cacheKey) {
        return cacheKey.split("\\$")[1];
    }

    public XmlInfo getAncestor() {
        return this.ancestor;
    }

    public String getURI() {
        return this.uri;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Class<? extends SourceLoader> getReaderClass() {
        return XmlMetadataLoader.class;
    }

    public Class<? extends MetadataScanner> getScannerClass() {
        return this.scannerClass;
    }

    public void setScannerClass(Class<? extends MetadataScanner> scannerClass) {
        this.scannerClass = scannerClass;
    }

    public ConfigId getConfigId() {
        return this.configId;
    }

    public Set<ConfigId> getDependents() {
        return this.dependents;
    }

    public String getDirectory() {
        int idx = this.getLocalPath().indexOf(this.getFileName());
        if (idx > 0) {
            return this.getLocalPath().substring(0, idx - 1);
        }
        return "";
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlInfo)) {
            return false;
        }
        XmlInfo info = (XmlInfo)((Object)o);
        return Objects.equals(this.id, info.id) && Objects.equals(this.baseSourceClass, info.baseSourceClass) && Objects.equals(this.localPath, info.localPath) && Objects.equals(this.uri, info.uri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.baseSourceClass, this.localPath, this.uri);
    }

    public String toString() {
        return this.getFileName();
    }
}

