/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.config.reader.XmlMetadataLoader;
import net.n2oapp.framework.config.register.ConfigId;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.Origin;
import net.n2oapp.framework.config.register.XmlInfo;
import net.n2oapp.framework.config.register.dynamic.JavaSourceLoader;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.framework.config.register.storage.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterUtil {
    private static final Logger log = LoggerFactory.getLogger(RegisterUtil.class);
    public static String DEFAULT_DYNAMIC_LOCAL_PATH = "java/override/";

    public static ConfigId getConfigIdByLocalPath(String path, SourceTypeRegister sourceTypeRegister) {
        String[] parts = RegisterUtil.getIdAndPostfix(path);
        return new ConfigId(parts[0], sourceTypeRegister.get(parts[1]));
    }

    public static String[] getIdAndPostfix(String absolutePath) {
        int idx;
        String crossOsPath = absolutePath.replace('\\', '/');
        String filename = crossOsPath.substring(idx = crossOsPath.lastIndexOf("/") + 1);
        String[] parts = filename.split("\\.");
        if (parts.length != 3) {
            throw new IllegalStateException("Metadata filename '" + absolutePath + "' should canResolved identifier, type of n2oMetadata, xml extension. For example: ResourceGroup.object.xml");
        }
        return parts;
    }

    public static InfoConstructor createDynamicInfo(String id, Class<? extends SourceMetadata> sourceClass, SourceTypeRegister sourceTypeRegister) {
        InfoConstructor info = new InfoConstructor(new ConfigId(id, sourceTypeRegister.get(sourceClass)));
        info.setLocalPath(PathUtil.concatFileNameAndBasePath(info.getConfigId().getId() + "." + info.getConfigId().getType() + ".dynamic", DEFAULT_DYNAMIC_LOCAL_PATH));
        RegisterUtil.baseForDynamicInfo(info);
        return info;
    }

    public static InfoConstructor createFolderInfo(Node node, SourceTypeRegister sourceTypeRegister) {
        InfoConstructor info = RegisterUtil.createXmlInfo(node, sourceTypeRegister);
        info.setOverride(true);
        return info;
    }

    public static InfoConstructor createXmlInfo(Node node, SourceTypeRegister sourceTypeRegister) {
        return RegisterUtil.createXmlInfo(node.getLocalPath(), node.getURI(), sourceTypeRegister);
    }

    public static InfoConstructor createXmlInfo(String localPath, String uri, SourceTypeRegister sourceTypeRegister) {
        return RegisterUtil.createXmlInfo(null, localPath, uri, sourceTypeRegister);
    }

    public static InfoConstructor createXmlInfo(Class<? extends MetadataScanner> scannerClass, String localPath, String uri, SourceTypeRegister sourceTypeRegister) {
        InfoConstructor info = new InfoConstructor(RegisterUtil.getConfigIdByLocalPath(localPath, sourceTypeRegister));
        info.setLocalPath(localPath);
        info.setUri(uri);
        info.setScannerClass(scannerClass);
        RegisterUtil.baseForXmlInfo(info);
        return info;
    }

    @Deprecated
    private static void baseForDynamicInfo(InfoConstructor info) {
        info.setOrigin(Origin.dynamic);
        info.setReaderClass(JavaSourceLoader.class);
    }

    private static void baseForXmlInfo(InfoConstructor info) {
        info.setOrigin(Origin.xml);
        info.setReaderClass(XmlMetadataLoader.class);
    }

    public static <T extends SourceInfo> List<T> collectInfo(List<Node> nodes, Function<Node, T> mapper) {
        ArrayList<SourceInfo> infoList = new ArrayList<SourceInfo>();
        for (Node node : nodes) {
            try {
                infoList.add((SourceInfo)mapper.apply(node));
            }
            catch (Exception e) {
                log.error("Bad format config file [" + node.getName() + "]", (Throwable)e);
            }
        }
        return infoList;
    }

    public static List<XmlInfo> retrieveInfoTree(XmlInfo info, List<XmlInfo> infos) {
        infos.add(info);
        XmlInfo ancestor = info.getAncestor();
        if (ancestor != null) {
            RegisterUtil.retrieveInfoTree(ancestor, infos);
        }
        return infos;
    }
}

