/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.config.reader.MetadataNotFoundException;
import net.n2oapp.framework.config.register.route.RouteUtil;

public class N2oMetadataRegister
implements MetadataRegister {
    private Map<MetaKey, SourceInfo> register = new ConcurrentHashMap<MetaKey, SourceInfo>();

    public SourceInfo get(String id, Class<? extends SourceMetadata> sourceClass) {
        MetaKey key = new MetaKey(RouteUtil.parsePath(id), sourceClass);
        if (!this.register.containsKey(key)) {
            throw new MetadataNotFoundException(id, sourceClass);
        }
        return this.register.get(key);
    }

    public List<SourceInfo> find(Class<? extends SourceMetadata> sourceClass) {
        return this.register.entrySet().stream().filter(e -> ((MetaKey)e.getKey()).sourceClass.equals(sourceClass)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<SourceInfo> find(Predicate<SourceInfo> criteria) {
        return this.register.values().stream().filter(criteria).collect(Collectors.toList());
    }

    public <I extends SourceInfo> List<I> find(Predicate<I> criteria, Class<I> infoClass) {
        return this.register.values().stream().filter(infoClass::isInstance).map(infoClass::cast).filter(criteria).collect(Collectors.toList());
    }

    public boolean contains(String id, Class<? extends SourceMetadata> sourceClass) {
        return this.register.containsKey(new MetaKey(RouteUtil.parsePath(id), sourceClass));
    }

    public <I extends SourceInfo> void add(I info) {
        MetaKey key = new MetaKey(info.getId(), info.getBaseSourceClass());
        this.register.put(key, info);
    }

    public <I extends SourceInfo> void addAll(Collection<I> infoList) {
        infoList.forEach(this::add);
    }

    public void remove(String id, Class<? extends SourceMetadata> sourceClass) {
        this.register.remove(new MetaKey(RouteUtil.parsePath(id), sourceClass));
    }

    public <I extends SourceInfo> void update(I info) {
    }

    public void clearAll() {
        this.register.clear();
    }

    static class MetaKey
    implements Serializable {
        private String id;
        private Class<? extends Source> sourceClass;

        MetaKey(String id, Class<? extends Source> sourceClass) {
            if (id == null) {
                throw new IllegalArgumentException("Id must not be null");
            }
            if (sourceClass == null) {
                throw new IllegalArgumentException("SourceClass must not be null");
            }
            this.id = id;
            this.sourceClass = sourceClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetaKey)) {
                return false;
            }
            MetaKey compare = (MetaKey)o;
            return this.id.equalsIgnoreCase(compare.id) && (compare.sourceClass.equals(this.sourceClass) || compare.sourceClass.isAssignableFrom(this.sourceClass));
        }

        public int hashCode() {
            return Objects.hash(this.id.toLowerCase());
        }

        public String toString() {
            return this.id + "." + this.sourceClass.getSimpleName();
        }
    }
}

