/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.config.io.MetadataParamHolder;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.N2oMetadataReaderException;
import net.n2oapp.framework.config.register.XmlInfo;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class XmlMetadataLoader
implements SourceLoader<XmlInfo> {
    private NamespaceReaderFactory elementReaderFactory;

    public XmlMetadataLoader(NamespaceReaderFactory elementReaderFactory) {
        this.elementReaderFactory = elementReaderFactory;
    }

    public <S extends SourceMetadata> S load(XmlInfo info, String params) {
        Class sourceClass = info.getBaseSourceClass();
        try {
            Object t;
            block13: {
                InputStream inputStream = FileSystemUtil.getContentAsStream(info.getURI());
                try {
                    MetadataParamHolder.setParams(RouteUtil.parseQueryParams(params));
                    Object source = this.read(info.getId(), inputStream);
                    if (!sourceClass.isAssignableFrom(source.getClass())) {
                        throw new MetadataReaderException("read class [" + String.valueOf(source.getClass()) + "], but expected [" + String.valueOf(sourceClass) + "]");
                    }
                    t = source;
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (N2oException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new N2oMetadataReaderException(e, info.getId(), info.getURI(), info.getConfigId().getType());
                    }
                }
                inputStream.close();
            }
            return (S)t;
        }
        finally {
            MetadataParamHolder.setParams(null);
        }
    }

    public <T extends SourceMetadata> T read(String id, String xml) {
        return this.read(id, IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8));
    }

    public <T extends SourceMetadata> T read(String id, InputStream xml) {
        Document doc;
        try {
            doc = SelectiveUtil.getSAXBuilder().build(xml);
        }
        catch (IOException | JDOMException e) {
            throw new N2oException("Error reading metadata " + id, e);
        }
        Element root = doc.getRootElement();
        SourceMetadata n2o = (SourceMetadata)this.elementReaderFactory.produce(root).read(root);
        if (n2o == null) {
            throw new MetadataReaderException("Xml Element Reader must return not null object");
        }
        n2o.setId(id);
        return (T)n2o;
    }

    public <T extends SourceMetadata> T read(String id, InputStream xml, Class<T> metadataClass) {
        T n2o = this.read(id, xml);
        if (!metadataClass.isAssignableFrom(n2o.getClass())) {
            throw new MetadataReaderException("read class [" + String.valueOf(n2o.getClass()) + "], but expected [" + String.valueOf(metadataClass) + "]");
        }
        return n2o;
    }
}

