/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.persister.util;

import java.util.Arrays;
import java.util.List;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.persister.ElementPersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PersisterJdomUtil {
    public static void setAttribute(Element element, String attribute, String value) {
        if (element == null) {
            return;
        }
        if (value == null) {
            return;
        }
        element.setAttribute(attribute, value);
    }

    public static void setAttribute(Element element, String attribute, Integer value) {
        if (element == null) {
            return;
        }
        if (value == null) {
            return;
        }
        element.setAttribute(attribute, value.toString());
    }

    public static void setAttribute(Element element, String attribute, Boolean value) {
        if (element == null) {
            return;
        }
        if (value == null) {
            return;
        }
        element.setAttribute(attribute, value.toString());
    }

    public static void setAttribute(Element element, String attribute, Enum value) {
        if (element == null) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value instanceof IdAware) {
            element.setAttribute(attribute, ((IdAware)value).getId());
        } else {
            element.setAttribute(attribute, value.name());
        }
    }

    public static Element setElement(String elementName) {
        return new Element(elementName);
    }

    public static Element setElement(String elementName, String prefix, String uri) {
        return new Element(elementName, Namespace.getNamespace((String)prefix, (String)uri));
    }

    public static Element setElement(Element parentElement, String elementName) {
        Element element = new Element(elementName, parentElement.getNamespace());
        parentElement.addContent((Content)element);
        return element;
    }

    public static Element setElementString(Element element, String elementName, String value) {
        Element subElement = null;
        if (value != null && element != null) {
            subElement = new Element(elementName, element.getNamespace());
            subElement.setText(value);
            element.addContent((Content)subElement);
        }
        return subElement;
    }

    public static Element setElementBoolean(Element element, String elementName, Boolean value) {
        Element subElement = null;
        if (value != null && element != null) {
            subElement = new Element(elementName, element.getNamespace());
            subElement.setText(value.toString());
            element.addContent((Content)subElement);
        }
        return subElement;
    }

    public static void setElementInteger(Element element, String elementName, Integer value) {
        if (element == null) {
            return;
        }
        if (value != null) {
            Element subElement = new Element(elementName, element.getNamespace());
            subElement.setText(value.toString());
            element.addContent((Content)subElement);
        }
    }

    public static Element setEmptyElement(Element element, String elementName) {
        Element subElement = null;
        if (element != null) {
            subElement = new Element(elementName, element.getNamespace());
            element.addContent((Content)subElement);
        }
        return subElement;
    }

    public static <E> Element setChild(Element element, String childName, E value, ElementPersister<E> persister) {
        if (element == null) {
            return null;
        }
        if (value != null) {
            Element child = persister.persist(value, element.getNamespace());
            if (childName != null) {
                child.setName(childName);
            }
            PersisterJdomUtil.replaceNoNamespace(child, element.getNamespace());
            element.addContent((Content)child);
            return child;
        }
        return null;
    }

    public static <E> void setChildren(Element element, E[] values, ElementPersister<E> persister) {
        if (values == null) {
            return;
        }
        PersisterJdomUtil.setChildrenAsList(element, null, null, Arrays.asList(values), persister);
    }

    public static <E> void setChildrenAsList(Element element, List<E> values, ElementPersister<E> persister) {
        PersisterJdomUtil.setChildrenAsList(element, null, null, values, persister);
    }

    public static <E> void setChildren(Element element, String sequenceName, String childName, E[] values, ElementPersister<E> persister) {
        if (values == null) {
            return;
        }
        PersisterJdomUtil.setChildrenAsList(element, sequenceName, childName, Arrays.asList(values), persister);
    }

    public static <E> void setChildrenAsList(Element element, String sequenceName, String childName, List<E> values, ElementPersister<E> persister) {
        if (values == null) {
            return;
        }
        if (element == null) {
            return;
        }
        Element sequences = element;
        if (sequenceName != null) {
            sequences = new Element(sequenceName, element.getNamespace());
            element.addContent((Content)sequences);
        }
        for (E value : values) {
            Element subChild = persister.persist(value, element.getNamespace());
            if (childName != null) {
                subChild.setName(childName);
            }
            PersisterJdomUtil.replaceNoNamespace(subChild, element.getNamespace());
            sequences.addContent((Content)subChild);
            PersisterJdomUtil.installPrefix(subChild, sequences);
        }
        if (sequences != element) {
            PersisterJdomUtil.installPrefix(sequences, element);
        }
    }

    public static <E extends NamespaceUriAware> void setChildren(Element element, String sequenceName, String childName, E[] values, NamespacePersisterFactory persisterFactory, String defaultNamespaceUri) {
        if (values == null) {
            return;
        }
        PersisterJdomUtil.setChildrenAsList(element, sequenceName, childName, Arrays.asList(values), persisterFactory, defaultNamespaceUri);
    }

    public static <E extends NamespaceUriAware> void setChildrenAsList(Element element, String sequenceName, String childName, List<E> values, NamespacePersisterFactory persisterFactory, String defaultNamespaceUri) {
        if (values == null) {
            return;
        }
        if (element == null) {
            return;
        }
        Element sequences = element;
        if (sequenceName != null) {
            sequences = new Element(sequenceName, element.getNamespace());
            element.addContent((Content)sequences);
        }
        for (NamespaceUriAware value : values) {
            NamespacePersister persister;
            try {
                persister = persisterFactory.produce(value);
            }
            catch (EngineNotFoundException ex) {
                persister = persisterFactory.produce(value.getClass(), new Namespace[]{Namespace.getNamespace((String)defaultNamespaceUri)});
            }
            Element subChild = persister.persist((Object)value, element.getNamespace());
            if (childName != null) {
                subChild.setName(childName);
            }
            if (subChild.getNamespace() == null || persister.getNamespaceUri() != null && persister.getNamespaceUri().equals(defaultNamespaceUri)) {
                PersisterJdomUtil.replaceNamespace(subChild, subChild.getNamespace(), element.getNamespace());
            }
            sequences.addContent((Content)subChild);
            PersisterJdomUtil.installPrefix(subChild, sequences);
        }
        if (sequences != element) {
            PersisterJdomUtil.installPrefix(sequences, element);
        }
    }

    public static void installPrefix(Element element, Element rootElement) {
        if (element == null) {
            return;
        }
        if (rootElement.getNamespace() == null) {
            return;
        }
        if (element.getNamespacePrefix() == null) {
            return;
        }
        if (element.getNamespace() == null) {
            return;
        }
        if (element.getNamespace().getURI().equals(rootElement.getNamespace().getURI())) {
            return;
        }
        if (element.getNamespace().getURI().isEmpty()) {
            return;
        }
        if (rootElement.getAdditionalNamespaces().contains(element.getNamespace())) {
            return;
        }
        Namespace additional = element.getNamespace();
        rootElement.addNamespaceDeclaration(additional);
    }

    public static void replaceNamespace(Element element, Namespace source, Namespace target) {
        if (target == null) {
            return;
        }
        if (element == null) {
            return;
        }
        if (element.getNamespace() != null && element.getNamespace().equals((Object)target)) {
            return;
        }
        if (element.getNamespace() != null && !element.getNamespace().equals((Object)source)) {
            return;
        }
        element.setNamespace(target);
        for (Object child : element.getChildren()) {
            if (!(child instanceof Element)) continue;
            PersisterJdomUtil.replaceNamespace((Element)child, source, target);
        }
    }

    public static void replaceNoNamespace(Element element, Namespace namespace) {
        PersisterJdomUtil.replaceNamespace(element, Namespace.NO_NAMESPACE, namespace);
    }

    @Deprecated
    public static <E> void setSubChild(Element element, String sequenceName, String childName, E[] values, ElementPersister<E> persister) {
        PersisterJdomUtil.setChildren(element, sequenceName, childName, values, persister);
    }

    @Deprecated
    public static <E> void setChilds(Element element, String childName, E[] values, ElementPersister<E> persister) {
        PersisterJdomUtil.setChildren(element, null, childName, values, persister);
    }

    @Deprecated
    public static <E> void setChilds(Element element, String childName, List<E> values, ElementPersister<E> persister) {
        PersisterJdomUtil.setChildrenAsList(element, null, childName, values, persister);
    }
}

