/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.persister;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.aware.PersisterFactoryAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import org.jdom2.Namespace;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class N2oMetadataPersisterFactory
implements NamespacePersisterFactory<NamespaceUriAware, NamespacePersister<NamespaceUriAware>>,
ApplicationContextAware,
IOProcessorAware {
    private ApplicationContext context;
    private IOProcessor processor;
    private volatile Map<String, Map<Class, NamespacePersister<NamespaceUriAware>>> engines;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public NamespacePersister<NamespaceUriAware> produce(Class clazz, Namespace ... namespaces) {
        if (this.engines == null) {
            this.initFactory();
        }
        HashMap<Class, NamespacePersister<NamespaceUriAware>> typedEngines = new HashMap<Class, NamespacePersister<NamespaceUriAware>>();
        for (Namespace namespace : namespaces) {
            if (!this.engines.containsKey(namespace.getURI())) continue;
            typedEngines.putAll(this.engines.get(namespace.getURI()));
        }
        if (typedEngines.isEmpty()) {
            throw new EngineNotFoundException((Object)clazz);
        }
        NamespacePersister persister = (NamespacePersister)typedEngines.get(clazz);
        if (persister == null) {
            throw new EngineNotFoundException((Object)clazz);
        }
        if (persister instanceof PersisterFactoryAware) {
            ((PersisterFactoryAware)persister).setPersisterFactory((NamespacePersisterFactory)this);
        }
        if (persister instanceof IOProcessorAware) {
            ((IOProcessorAware)persister).setIOProcessor(this.processor);
        }
        return persister;
    }

    public void add(NamespacePersister<NamespaceUriAware> persister) {
        throw new UnsupportedOperationException();
    }

    private synchronized void initFactory() {
        if (this.engines == null) {
            this.engines = new HashMap<String, Map<Class, NamespacePersister<NamespaceUriAware>>>();
            ArrayList beans = new ArrayList(this.context.getBeansOfType(NamespacePersister.class).values());
            if (this.processor != null) {
                for (NamespaceIO ioBean : this.context.getBeansOfType(NamespaceIO.class).values()) {
                    beans.add(new ProxyNamespaceIO(ioBean, this.processor));
                }
            }
            beans.forEach(b -> {
                if (this.engines.containsKey(b.getNamespaceUri())) {
                    this.engines.get(b.getNamespaceUri()).put(b.getElementClass(), (NamespacePersister<NamespaceUriAware>)b);
                } else {
                    HashMap<Class, NamespacePersister> typedEngines = new HashMap<Class, NamespacePersister>();
                    typedEngines.put(b.getElementClass(), (NamespacePersister)b);
                    this.engines.put(b.getNamespaceUri(), typedEngines);
                }
            });
        }
    }

    public void setIOProcessor(IOProcessor processor) {
        this.processor = processor;
    }
}

