/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.ActionBar;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.datasource.ValidatorDataSourcesScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class WidgetValidator<T extends N2oWidget>
implements SourceValidator<T>,
SourceClassAware {
    public void validate(T source, SourceProcessor p) {
        MetaActions pageActions = (MetaActions)p.getScope(MetaActions.class);
        this.checkActionIds(source, pageActions, p);
        MetaActions allMetaActions = this.getAllMetaActions(pageActions, source.getActions(), p);
        if (source.getActions() != null) {
            Stream.of(source.getActions()).forEach(actionbar -> ValidationUtils.checkOnFailAction(actionbar.getN2oActions()));
        }
        ComponentScope componentScope = new ComponentScope(source);
        if (source.getDatasource() != null) {
            WidgetScope widgetScope = new WidgetScope(source.getId(), source.getDatasource(), null, (CompileProcessor)((N2oCompileProcessor)p));
            p.validate((Source)source.getDatasource(), new Object[]{widgetScope});
            ValidatorDataSourcesScope datasourcesScope = (ValidatorDataSourcesScope)p.getScope(ValidatorDataSourcesScope.class);
            if (datasourcesScope != null && !datasourcesScope.containsKey(source.getDatasource().getId())) {
                datasourcesScope.put(source.getDatasource().getId(), source.getDatasource());
            }
        }
        if (source.getToolbars() != null) {
            ArrayList<N2oButton> menuItems = new ArrayList<N2oButton>();
            for (N2oToolbar toolbar : source.getToolbars()) {
                if (toolbar.getItems() == null) continue;
                for (ToolbarItem item : toolbar.getItems()) {
                    N2oSubmenu submenu;
                    if (item instanceof N2oButton) {
                        N2oButton n2oButton = (N2oButton)item;
                        menuItems.add(n2oButton);
                        continue;
                    }
                    if (!(item instanceof N2oSubmenu) || (submenu = (N2oSubmenu)item).getMenuItems() == null) continue;
                    menuItems.addAll(Arrays.asList(submenu.getMenuItems()));
                }
            }
            p.safeStreamOf(menuItems).forEach(menuItem -> p.validate((Source)menuItem, new Object[]{componentScope, allMetaActions}));
            p.checkIdsUnique(menuItems, String.format("\u041a\u043d\u043e\u043f\u043a\u0430 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '%s'", "%s", source.getId()));
        }
        if (source.getDatasourceId() != null) {
            this.checkDatasource(source, p);
        }
        this.checkDependencies(source);
        p.safeStreamOf((Object[])source.getActions()).flatMap(actionBar -> p.safeStreamOf((Object[])actionBar.getN2oActions())).forEach(action -> p.validate((Source)action, new Object[]{componentScope}));
        this.checkEmptyToolbar(source);
    }

    private void checkEmptyToolbar(T source) {
        if (source.getToolbars() != null) {
            for (N2oToolbar toolbar : source.getToolbars()) {
                if (toolbar.getItems() != null || toolbar.getGenerate() != null) continue;
                throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u0438\u043b\u0438 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 'generate' \u0432 \u0442\u0443\u043b\u0431\u0430\u0440\u0435 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 '%s'", source.getId()));
            }
        }
    }

    private void checkDependencies(T source) {
        if (source.getDependencies() != null) {
            Arrays.stream(source.getDependencies()).forEach(dependency -> ValidationUtils.checkEmptyDependency(dependency, String.format("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u0432\u0438\u0434\u0436\u0435\u0442\u0430 %s \u0438\u043c\u0435\u0435\u0442 \u043f\u0443\u0441\u0442\u043e\u0435 \u0442\u0435\u043b\u043e", ValidationUtils.getIdOrEmptyString(source.getId()))));
        }
    }

    protected MetaActions getAllMetaActions(MetaActions pageActions, ActionBar[] widgetActions, SourceProcessor p) {
        MetaActions result = new MetaActions();
        if (pageActions != null) {
            result.putAll(pageActions);
        }
        result.putAll(p.safeStreamOf((Object[])widgetActions).collect(Collectors.toMap(ActionBar::getId, Function.identity())));
        return result;
    }

    private void checkActionIds(T source, MetaActions pageActions, SourceProcessor p) {
        if (ArrayUtils.isEmpty((Object[])source.getActions())) {
            return;
        }
        ActionBar[] widgetActions = source.getActions();
        Arrays.stream(widgetActions).forEach(action -> {
            if (action.getId() == null) {
                throw new N2oMetadataValidationException(String.format("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d 'id' \u0443 <action> \u0432\u0438\u0434\u0436\u0435\u0442\u0430 '%s'", source.getId()));
            }
        });
        p.checkIdsUnique((IdAware[])widgetActions, String.format("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 '%s'", "%s", source.getId()));
        if (pageActions == null) {
            return;
        }
        for (ActionBar widgetAction : widgetActions) {
            if (!pageActions.containsKey(widgetAction.getId())) continue;
            throw new N2oMetadataValidationException(String.format("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f '%s' \u0434\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0438 \u0432 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '%s'", widgetAction.getId(), source.getId()));
        }
    }

    private void checkDatasource(T widget, SourceProcessor p) {
        if (widget.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(widget.getDatasourceId(), p, String.format("\u0412\u0438\u0434\u0436\u0435\u0442 %s c\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", ValidationUtils.getIdOrEmptyString(widget.getId()), widget.getDatasourceId()));
        }
        if (widget.getDatasource() != null && widget.getDatasourceId() != null) {
            throw new N2oMetadataValidationException(String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0438 \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e", widget.getId()));
        }
    }
}

