/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.regions;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.ValidationUtils;
import net.n2oapp.framework.config.metadata.validation.standard.regions.AbstractRegionValidator;
import org.springframework.stereotype.Component;

@Component
public class TabsValidator
extends AbstractRegionValidator<N2oTabsRegion> {
    public Class<? extends Source> getSourceClass() {
        return N2oTabsRegion.class;
    }

    @Override
    public void validate(N2oTabsRegion source, SourceProcessor p) {
        if (source.getTabs() == null) {
            throw new N2oMetadataValidationException("\u0412 \u0440\u0435\u0433\u0438\u043e\u043d\u0435 <tabs> \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0432\u043a\u043b\u0430\u0434\u043a\u0438 <tab>");
        }
        if (source.getDatasourceId() != null) {
            ValidationUtils.checkDatasourceExistence(source.getDatasourceId(), p, String.format("\u0420\u0435\u0433\u0438\u043e\u043d <tabs> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 '%s'", source.getDatasourceId()));
        }
        Arrays.stream(source.getTabs()).forEach(tab -> this.validateTab((N2oTabsRegion.Tab)tab, p));
    }

    private void validateTab(N2oTabsRegion.Tab source, SourceProcessor p) {
        if (source.getDatasource() != null) {
            ValidationUtils.checkDatasourceExistence(source.getDatasource(), p, String.format("\u0412\u043a\u043b\u0430\u0434\u043a\u0430 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 %s", ValidationUtils.getIdOrEmptyString(source.getName()), ValidationUtils.getIdOrEmptyString(source.getDatasource())));
        }
        p.safeStreamOf((Object[])source.getContent()).forEach(x$0 -> p.validate(x$0, new Object[0]));
    }
}

